/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.synthesizer.vibration;

import com.mojang.serialization.DynamicOps;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.synthesizer.AbstractSynthesizerBlockEntity;
import sirttas.elementalcraft.block.synthesizer.vibration.VibrationSynthesizerBlock;
import sirttas.elementalcraft.range.RangeRenderTimer;
import sirttas.elementalcraft.tag.ECTags;

public class VibrationSynthesizerBlockEntity
extends AbstractSynthesizerBlockEntity
implements GameEventListener.Provider<VibrationSystem.Listener>,
VibrationSystem {
    public static final ResourceKey<IConfigurableBlockEntityProperties> PROPERTIES_KEY = IConfigurableBlockEntityProperties.createKey("vibration_air_synthesizer");
    private static final Holder<IConfigurableBlockEntityProperties> PROPERTIES = ElementalCraft.CONFIGURABLE_BLOCK_ENTITY_PROPERTIES_MANAGER.getOrCreateHolder(PROPERTIES_KEY);
    private final RangeRenderTimer rangeRenderTimer = new RangeRenderTimer();
    private VibrationSystem.Data vibrationData = new VibrationSystem.Data();
    private final VibrationSystem.Listener vibrationListener = new VibrationSystem.Listener((VibrationSystem)this);
    private final VibrationSystem.User vibrationUser;

    public VibrationSynthesizerBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.VIBRATION_SYNTHESIZER, PROPERTIES, pos, state);
        this.vibrationUser = new VibrationUser(pos);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, VibrationSynthesizerBlockEntity vibrationSynthesizer) {
        vibrationSynthesizer.handleSynthesis();
        VibrationSystem.Ticker.tick((Level)level, (VibrationSystem.Data)vibrationSynthesizer.vibrationData, (VibrationSystem.User)vibrationSynthesizer.vibrationUser);
    }

    @Override
    protected int synthesizeElement() {
        return 0;
    }

    public boolean showsRange() {
        return this.rangeRenderTimer.showsRange();
    }

    public void startShowingRange() {
        this.rangeRenderTimer.startShowingRange();
    }

    @NotNull
    public VibrationSystem.Listener getListener() {
        return this.vibrationListener;
    }

    @NotNull
    public VibrationSystem.Data getVibrationData() {
        return this.vibrationData;
    }

    @NotNull
    public VibrationSystem.User getVibrationUser() {
        return this.vibrationUser;
    }

    @Override
    protected void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        if (compound.contains("listener", 10)) {
            VibrationSystem.Data.CODEC.parse((DynamicOps)ops, (Object)compound.getCompound("listener")).resultOrPartial(message -> ElementalCraftApi.LOGGER.error("Failed to parse vibration listener for vibration air synthesizer: '{}'", message)).ifPresent(data -> {
                this.vibrationData = data;
            });
        }
    }

    @Override
    protected void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        VibrationSystem.Data.CODEC.encodeStart((DynamicOps)ops, (Object)this.vibrationData).resultOrPartial(message -> ElementalCraftApi.LOGGER.error("Failed to encode vibration listener for vibration air synthesizer: '{}'", message)).ifPresent(tag -> compound.put("listener", tag));
    }

    private class VibrationUser
    implements VibrationSystem.User {
        private final PositionSource positionSource;

        private VibrationUser(BlockPos pos) {
            this.positionSource = new BlockPositionSource(pos);
        }

        public int getListenerRadius() {
            AABB range = VibrationSynthesizerBlockEntity.this.getRange();
            return (int)Math.round(range.getSize() * 2.0);
        }

        @NotNull
        public PositionSource getPositionSource() {
            return this.positionSource;
        }

        public boolean canReceiveVibration(@NotNull ServerLevel serverLevel, @NotNull BlockPos pos, @NotNull Holder<GameEvent> gameEvent, @NotNull GameEvent.Context context) {
            return pos != VibrationSynthesizerBlockEntity.this.getBlockPos() && VibrationSynthesizerBlockEntity.this.getRange().contains(pos.getCenter()) && VibrationSynthesizerBlockEntity.this.getBlockState().getValue(VibrationSynthesizerBlock.PHASE) == SculkSensorPhase.INACTIVE && gameEvent.is(ECTags.GameEvents.SYNTHESIZABLE_TO_AIR);
        }

        public void onReceiveVibration(@NotNull ServerLevel serverLevel, @NotNull BlockPos pos, @NotNull Holder<GameEvent> gameEvent, @Nullable Entity entity, @Nullable Entity owner, float range) {
            BlockState state = VibrationSynthesizerBlockEntity.this.getBlockState();
            VibrationSynthesizerBlockEntity.this.getElementStorage().insertElement(Math.round(VibrationSynthesizerBlockEntity.this.synthesisMultiplier), ElementType.AIR, false);
            serverLevel.setBlockAndUpdate(pos, (BlockState)state.setValue(VibrationSynthesizerBlock.PHASE, (Comparable)SculkSensorPhase.ACTIVE));
            serverLevel.scheduleTick(pos, state.getBlock(), 30);
            serverLevel.playSound(null, (double)VibrationSynthesizerBlockEntity.this.worldPosition.getX() + 0.5, (double)VibrationSynthesizerBlockEntity.this.worldPosition.getY() + 0.5, (double)VibrationSynthesizerBlockEntity.this.worldPosition.getZ() + 0.5, SoundEvents.SCULK_CLICKING, SoundSource.BLOCKS, 1.0f, serverLevel.random.nextFloat() * 0.2f + 0.8f);
        }
    }
}

