/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.synthesizer.vibration;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.AbstractECContainerBlock;
import sirttas.elementalcraft.block.container.ElementContainer;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.synthesizer.AbstractSynthesizerBlockEntity;
import sirttas.elementalcraft.block.synthesizer.vibration.VibrationSynthesizerBlockEntity;

public class VibrationSynthesizerBlock
extends AbstractECContainerBlock {
    public static final String NAME = "vibration_air_synthesizer";
    public static final MapCodec<VibrationSynthesizerBlock> CODEC = VibrationSynthesizerBlock.simpleCodec(VibrationSynthesizerBlock::new);
    private static final VoxelShape BASE_1 = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0);
    private static final VoxelShape BASE_2 = Block.box((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)3.0, (double)12.0);
    private static final VoxelShape BASE_3 = Block.box((double)5.0, (double)3.0, (double)5.0, (double)7.0, (double)4.0, (double)7.0);
    private static final VoxelShape BASE_4 = Block.box((double)9.0, (double)3.0, (double)5.0, (double)11.0, (double)4.0, (double)7.0);
    private static final VoxelShape BASE_5 = Block.box((double)5.0, (double)3.0, (double)9.0, (double)7.0, (double)4.0, (double)11.0);
    private static final VoxelShape BASE_6 = Block.box((double)9.0, (double)3.0, (double)9.0, (double)11.0, (double)4.0, (double)11.0);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)BASE_1, (VoxelShape[])new VoxelShape[]{BASE_2, BASE_3, BASE_4, BASE_5, BASE_6});
    public static final EnumProperty<SculkSensorPhase> PHASE = BlockStateProperties.SCULK_SENSOR_PHASE;

    public VibrationSynthesizerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(PHASE, (Comparable)SculkSensorPhase.INACTIVE));
    }

    @NotNull
    protected MapCodec<? extends VibrationSynthesizerBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new VibrationSynthesizerBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return VibrationSynthesizerBlock.createECServerTicker(level, type, ECBlockEntityTypes.VIBRATION_SYNTHESIZER, VibrationSynthesizerBlockEntity::serverTick);
    }

    protected void tick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource source) {
        SculkSensorPhase phase = VibrationSynthesizerBlock.getPhase(state);
        if (phase == SculkSensorPhase.ACTIVE) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue(PHASE, (Comparable)SculkSensorPhase.COOLDOWN));
            level.scheduleTick(pos, state.getBlock(), 10);
        } else if (phase == SculkSensorPhase.COOLDOWN) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue(PHASE, (Comparable)SculkSensorPhase.INACTIVE));
        }
    }

    @Nonnull
    protected ItemInteractionResult useItemOn(@Nonnull ItemStack stack, @Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @NotNull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        VibrationSynthesizerBlockEntity synthesizer = (VibrationSynthesizerBlockEntity)level.getBlockEntity(pos);
        if (synthesizer != null && player.getItemInHand(hand).isEmpty() && player.isShiftKeyDown()) {
            if (level.isClientSide) {
                synthesizer.startShowingRange();
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    public void animateTick(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        AbstractSynthesizerBlockEntity.renderElementFlow(level, pos, rand);
    }

    public boolean canSurvive(@Nonnull BlockState state, @Nonnull LevelReader level, BlockPos pos) {
        return ElementContainer.isValidContainer(state, level, pos.below());
    }

    public static SculkSensorPhase getPhase(BlockState state) {
        return (SculkSensorPhase)state.getValue(PHASE);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PHASE});
    }
}

