/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.synthesizer.solar;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.synthesizer.solar.SolarSynthesizerBlockEntity;
import sirttas.elementalcraft.client.model.ECModelHelper;
import sirttas.elementalcraft.renderer.ECRendererHelper;

public class SolarSynthesizerRenderer
implements BlockEntityRenderer<SolarSynthesizerBlockEntity> {
    public static final Material BEAM = ECRendererHelper.getBlockMaterial("effect/solar_fire_synthesizer_beam");
    public static final ModelResourceLocation LENS_LOCATION = ECModelHelper.standalone("block/solar_fire_synthesizer_lens");
    private static final float RED = ElementType.FIRE.getRed();
    private static final float GREEN = ElementType.FIRE.getGreen();
    private static final float BLUE = ElementType.FIRE.getBlue();
    private static BakedModel lensModel;

    public void render(SolarSynthesizerBlockEntity solarSynthesizer, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        ECRendererHelper.renderRunes(matrixStack, buffer, solarSynthesizer.getRuneHandler(), ECRendererHelper.getClientTicks(partialTicks), light, overlay);
        Minecraft minecraft = Minecraft.getInstance();
        boolean receivingSkyLight = solarSynthesizer.isReceivingSkyLight();
        matrixStack.pushPose();
        matrixStack.translate(0.5, 0.90625, 0.5);
        if (receivingSkyLight) {
            matrixStack.mulPose(Axis.ZP.rotation(solarSynthesizer.getLevel().getSunAngle(partialTicks)));
        } else {
            matrixStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        }
        matrixStack.translate(-0.1875, -0.03125, -0.1875);
        minecraft.getBlockRenderer().getModelRenderer().renderModel(matrixStack.last(), buffer.getBuffer(RenderType.translucent()), solarSynthesizer.getBlockState(), this.getLensModel(), RED, GREEN, BLUE, light, overlay, ECRendererHelper.getModelData(this.getLensModel(), solarSynthesizer), RenderType.translucent());
        matrixStack.popPose();
        if (receivingSkyLight) {
            Vec3 beamVect = Vec3.atCenterOf((Vec3i)solarSynthesizer.getBlockPos()).subtract(minecraft.getEntityRenderDispatcher().camera.getPosition()).multiply(1.0, 0.0, 1.0).normalize();
            matrixStack.pushPose();
            matrixStack.translate(0.5, 0.5, 0.5);
            matrixStack.mulPose(Axis.YP.rotation((float)Math.acos(beamVect.z * (double)(beamVect.x > 0.0 ? 1 : -1))));
            matrixStack.scale(0.006f, 0.006f, 0.006f);
            ECRendererHelper.renderIcon(matrixStack, buffer, -21.0f, 38.0f, BEAM, 42, -76, RED, GREEN, BLUE, light, overlay);
            matrixStack.popPose();
        }
    }

    protected ElementType getElementType(SolarSynthesizerBlockEntity te) {
        return ElementType.getElementType(te.getInventory().getItem(0));
    }

    private synchronized BakedModel getLensModel() {
        if (lensModel == null) {
            Minecraft minecraft = Minecraft.getInstance();
            lensModel = minecraft.getModelManager().getModel(LENS_LOCATION);
        }
        return lensModel;
    }
}

