/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.synthesizer.solar;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.synthesizer.AbstractContainerSynthesizerBlockEntity;
import sirttas.elementalcraft.block.synthesizer.solar.SolarSynthesizerContainer;
import sirttas.elementalcraft.container.SingleStackContainer;

public class SolarSynthesizerBlockEntity
extends AbstractContainerSynthesizerBlockEntity {
    private final SingleStackContainer inventory = new SolarSynthesizerContainer(this);
    public static final ResourceKey<IConfigurableBlockEntityProperties> PROPERTIES_KEY = IConfigurableBlockEntityProperties.createKey("solar_fire_synthesizer");
    private static final Holder<IConfigurableBlockEntityProperties> PROPERTIES = ElementalCraft.CONFIGURABLE_BLOCK_ENTITY_PROPERTIES_MANAGER.getOrCreateHolder(PROPERTIES_KEY);

    public SolarSynthesizerBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.SOLAR_SYNTHESIZER, PROPERTIES, pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, SolarSynthesizerBlockEntity solarSynthesizer) {
        solarSynthesizer.handleSynthesis();
    }

    @Override
    protected int getElementAmountForStack(ItemStack stack) {
        if (this.isReceivingSkyLight()) {
            return Math.round(this.synthesisMultiplier);
        }
        return 0;
    }

    protected boolean isReceivingSkyLight() {
        return this.level != null && this.level.dimensionType().hasSkyLight() && this.level.canSeeSky(this.worldPosition) && this.level.isDay();
    }

    @Override
    @NotNull
    public Container getInventory() {
        return this.inventory;
    }
}

