/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.synthesizer.solar;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.AbstractECContainerBlock;
import sirttas.elementalcraft.block.container.ElementContainer;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.synthesizer.AbstractSynthesizerBlockEntity;
import sirttas.elementalcraft.block.synthesizer.solar.SolarSynthesizerBlockEntity;
import sirttas.elementalcraft.tag.ECTags;

public class SolarSynthesizerBlock
extends AbstractECContainerBlock {
    public static final String NAME = "solar_fire_synthesizer";
    public static final MapCodec<SolarSynthesizerBlock> CODEC = SolarSynthesizerBlock.simpleCodec(SolarSynthesizerBlock::new);
    private static final VoxelShape BASE_1 = Block.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    private static final VoxelShape BASE_2 = Shapes.join((VoxelShape)Block.box((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0), (VoxelShape)Block.box((double)6.0, (double)4.0, (double)6.0, (double)10.0, (double)5.0, (double)10.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    private static final VoxelShape BASE_3 = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0);
    private static final VoxelShape PIPE_1 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)6.0, (double)3.0);
    private static final VoxelShape PIPE_2 = Block.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)6.0, (double)3.0);
    private static final VoxelShape PIPE_3 = Block.box((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)6.0, (double)15.0);
    private static final VoxelShape PIPE_4 = Block.box((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)6.0, (double)15.0);
    private static final VoxelShape PIPE_5 = Block.box((double)7.0, (double)5.0, (double)3.0, (double)9.0, (double)15.0, (double)5.0);
    private static final VoxelShape PIPE_6 = Block.box((double)7.0, (double)5.0, (double)11.0, (double)9.0, (double)15.0, (double)13.0);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)BASE_1, (VoxelShape[])new VoxelShape[]{BASE_2, BASE_3, PIPE_1, PIPE_2, PIPE_3, PIPE_4, PIPE_5, PIPE_6});

    public SolarSynthesizerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected MapCodec<? extends SolarSynthesizerBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new SolarSynthesizerBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return SolarSynthesizerBlock.createECServerTicker(level, type, ECBlockEntityTypes.SOLAR_SYNTHESIZER, SolarSynthesizerBlockEntity::serverTick);
    }

    @Nonnull
    protected ItemInteractionResult useItemOn(@Nonnull ItemStack stack, @Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @NotNull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        if (stack.isEmpty() || stack.is(ECTags.Items.LENSES)) {
            return this.onSingleSlotActivated(stack, level, pos, player, hand);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    public void animateTick(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        AbstractSynthesizerBlockEntity.renderElementFlow(level, pos, rand);
    }

    public boolean canSurvive(@Nonnull BlockState state, @Nonnull LevelReader level, BlockPos pos) {
        return ElementContainer.isValidContainer(state, level, pos.below());
    }
}

