/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.synthesizer.mill;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.AbstractECContainerBlock;
import sirttas.elementalcraft.block.WaterLoggingHelper;
import sirttas.elementalcraft.block.airmill.AirMill;
import sirttas.elementalcraft.block.container.ElementContainer;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.instrument.io.mill.AbstractAirMillBlock;
import sirttas.elementalcraft.block.shrine.AbstractPylonShrineBlock;
import sirttas.elementalcraft.block.synthesizer.AbstractSynthesizerBlockEntity;
import sirttas.elementalcraft.block.synthesizer.mill.AirMillSynthesizerBlockEntity;
import sirttas.elementalcraft.item.ECItems;

public class AirMillSynthesizerBlock
extends AbstractECContainerBlock {
    public static final String NAME = "air_mill_synthesizer";
    public static final MapCodec<AirMillSynthesizerBlock> CODEC = AirMillSynthesizerBlock.simpleCodec(AirMillSynthesizerBlock::new);
    private static final VoxelShape BASE_1 = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0);
    private static final VoxelShape BASE_2 = Block.box((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    private static final VoxelShape BASE_3 = Block.box((double)3.0, (double)8.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
    private static final VoxelShape SIDE_PILLAR_1 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)4.0, (double)3.0);
    private static final VoxelShape SIDE_PILLAR_2 = SIDE_PILLAR_1.move(0.75, 0.0, 0.0);
    private static final VoxelShape SIDE_PILLAR_3 = SIDE_PILLAR_1.move(0.0, 0.0, 0.75);
    private static final VoxelShape SIDE_PILLAR_4 = SIDE_PILLAR_1.move(0.75, 0.0, 0.75);
    private static final VoxelShape INNER_PILLAR_1 = Block.box((double)4.0, (double)3.0, (double)4.0, (double)6.0, (double)11.0, (double)6.0);
    private static final VoxelShape INNER_PILLAR_2 = INNER_PILLAR_1.move(0.375, 0.0, 0.0);
    private static final VoxelShape INNER_PILLAR_3 = INNER_PILLAR_1.move(0.0, 0.0, 0.375);
    private static final VoxelShape INNER_PILLAR_4 = INNER_PILLAR_1.move(0.375, 0.0, 0.375);
    private static final VoxelShape SHAFT = Block.box((double)7.0, (double)3.0, (double)7.0, (double)9.0, (double)10.0, (double)9.0);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)BASE_1, (VoxelShape[])new VoxelShape[]{BASE_2, BASE_3, SIDE_PILLAR_1, SIDE_PILLAR_2, SIDE_PILLAR_3, SIDE_PILLAR_4, INNER_PILLAR_1, INNER_PILLAR_2, INNER_PILLAR_3, INNER_PILLAR_4, SHAFT});
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;

    public AirMillSynthesizerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)AbstractAirMillBlock.BROKEN, (Comparable)Boolean.valueOf(false)));
    }

    protected boolean isLower(BlockState state) {
        return state.getValue(HALF) == DoubleBlockHalf.LOWER;
    }

    @NotNull
    protected MapCodec<? extends AirMillSynthesizerBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        if (!this.isLower(state)) {
            return null;
        }
        return new AirMillSynthesizerBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        if (!this.isLower(state)) {
            return null;
        }
        return AirMillSynthesizerBlock.createECServerTicker(level, type, ECBlockEntityTypes.AIR_MILL_SYNTHESIZER, AirMillSynthesizerBlockEntity::serverTick);
    }

    @Nonnull
    protected ItemInteractionResult useItemOn(@Nonnull ItemStack stack, @Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @NotNull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        if (!this.isLower(state)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (stack.isEmpty() || stack.is(ECItems.AIR_MILL)) {
            return AirMill.setMill(stack, state, level, pos, player, hand);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        level.setBlock(pos.above(), (BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    @NotNull
    public BlockState playerWillDestroy(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        AbstractPylonShrineBlock.doubleHalfHarvest(level, pos, state, player);
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Nonnull
    public BlockState updateShape(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        return AbstractPylonShrineBlock.doubleHalfUpdateShape(state, facing, facingState, level, pos, () -> {
            WaterLoggingHelper.scheduleWaterTick(state, level, pos);
            return !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, pos, facingPos);
        });
    }

    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        if (!AbstractPylonShrineBlock.canReplaceAboveBlock(context)) {
            return null;
        }
        return this.defaultBlockState();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF, AbstractAirMillBlock.BROKEN});
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return this.isLower(state) ? SHAPE : AbstractAirMillBlock.SHAPE_UPPER;
    }

    public void animateTick(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        AbstractSynthesizerBlockEntity.renderElementFlow(level, pos, rand);
    }

    public boolean canSurvive(@Nonnull BlockState state, @Nonnull LevelReader level, BlockPos pos) {
        BlockPos below = pos.below();
        return this.isLower(state) && ElementContainer.isValidContainer(state, level, below) || level.getBlockState(below).is((Block)this);
    }
}

