/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.synthesizer.draining;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.AbstractECContainerBlock;
import sirttas.elementalcraft.block.container.ElementContainer;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.synthesizer.AbstractSynthesizerBlockEntity;
import sirttas.elementalcraft.block.synthesizer.draining.DrainingSynthesizerBlockEntity;
import sirttas.elementalcraft.damagesource.ECDamageTypes;

public class DrainingSynthesizerBlock
extends AbstractECContainerBlock {
    public static final String NAME = "draining_water_synthesizer";
    public static final MapCodec<DrainingSynthesizerBlock> CODEC = DrainingSynthesizerBlock.simpleCodec(DrainingSynthesizerBlock::new);
    private static final VoxelShape BASE_1 = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0);
    private static final VoxelShape BASE_2 = Block.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0);
    private static final VoxelShape PIPE_1 = Block.box((double)3.0, (double)0.0, (double)3.0, (double)5.0, (double)8.0, (double)5.0);
    private static final VoxelShape PIPE_2 = Block.box((double)11.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)5.0);
    private static final VoxelShape PIPE_3 = Block.box((double)3.0, (double)0.0, (double)11.0, (double)5.0, (double)8.0, (double)13.0);
    private static final VoxelShape PIPE_4 = Block.box((double)11.0, (double)0.0, (double)11.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)BASE_1, (VoxelShape[])new VoxelShape[]{BASE_2, PIPE_1, PIPE_2, PIPE_3, PIPE_4});

    public DrainingSynthesizerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected MapCodec<? extends DrainingSynthesizerBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new DrainingSynthesizerBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return DrainingSynthesizerBlock.createECServerTicker(level, type, ECBlockEntityTypes.DRAINING_SYNTHESIZER, DrainingSynthesizerBlockEntity::serverTick);
    }

    @Nonnull
    protected ItemInteractionResult useItemOn(@Nonnull ItemStack stack, @Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @NotNull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        DrainingSynthesizerBlockEntity synthesizer = (DrainingSynthesizerBlockEntity)level.getBlockEntity(pos);
        if (synthesizer != null && synthesizer.needsElement()) {
            if (player.getFoodData().getFoodLevel() > 0) {
                player.causeFoodExhaustion(0.1f);
            } else {
                player.hurt(player.damageSources().source(ECDamageTypes.DRAINING, (Entity)player), 1.0f);
            }
            synthesizer.fill();
            return ItemInteractionResult.CONSUME;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    public void animateTick(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        AbstractSynthesizerBlockEntity.renderElementFlow(level, pos, rand);
    }

    public boolean canSurvive(@Nonnull BlockState state, @Nonnull LevelReader level, BlockPos pos) {
        return ElementContainer.isValidContainer(state, level, pos.below());
    }
}

