/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.synthesizer.culinary;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.synthesizer.AbstractContainerSynthesizerBlockEntity;
import sirttas.elementalcraft.block.synthesizer.culinary.CulinarySynthesizerContainer;
import sirttas.elementalcraft.container.SingleStackContainer;

public class CulinarySynthesizerBlockEntity
extends AbstractContainerSynthesizerBlockEntity {
    public static final ResourceKey<IConfigurableBlockEntityProperties> PROPERTIES_KEY = IConfigurableBlockEntityProperties.createKey("culinary_water_synthesizer");
    private static final Holder<IConfigurableBlockEntityProperties> PROPERTIES = ElementalCraft.CONFIGURABLE_BLOCK_ENTITY_PROPERTIES_MANAGER.getOrCreateHolder(PROPERTIES_KEY);
    private final SingleStackContainer inventory = new CulinarySynthesizerContainer(this);

    public CulinarySynthesizerBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.CULINARY_SYNTHESIZER, PROPERTIES, pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CulinarySynthesizerBlockEntity culinarySynthesizer) {
        culinarySynthesizer.handleSynthesis();
    }

    @Override
    protected int getElementAmountForStack(ItemStack stack) {
        FoodProperties foodProperties = stack.getFoodProperties(null);
        if (foodProperties == null) {
            return 0;
        }
        return Math.round(((float)foodProperties.nutrition() + foodProperties.saturation()) * this.synthesisMultiplier);
    }

    @Override
    @NotNull
    public Container getInventory() {
        return this.inventory;
    }
}

