/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.synthesizer.cracking;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import sirttas.elementalcraft.block.synthesizer.AbstractSynthesizerBlockEntity;
import sirttas.elementalcraft.block.synthesizer.cracking.AbstractCrackingSynthesizerBlockEntity;
import sirttas.elementalcraft.client.model.ECModelHelper;
import sirttas.elementalcraft.renderer.ECRendererHelper;

public class CrackingSynthesizerRenderer<T extends AbstractCrackingSynthesizerBlockEntity<?>>
implements BlockEntityRenderer<T> {
    public static final ModelResourceLocation HEAD_LOCATION = ECModelHelper.standalone("block/cracking_earth_synthesizer_head");
    private BakedModel headModel;

    public void render(T crackingSynthesizer, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int light, int overlay) {
        ECRendererHelper.renderRunes(poseStack, bufferSource, ((AbstractSynthesizerBlockEntity)crackingSynthesizer).getRuneHandler(), ECRendererHelper.getClientTicks(partialTicks), light, overlay);
        Minecraft minecraft = Minecraft.getInstance();
        if (((AbstractCrackingSynthesizerBlockEntity)crackingSynthesizer).showsRange()) {
            BlockPos pos = crackingSynthesizer.getBlockPos();
            LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)bufferSource.getBuffer(RenderType.lines()), (AABB)((AbstractSynthesizerBlockEntity)crackingSynthesizer).getRange().move((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ())), (float)1.0f, (float)1.0f, (float)0.6f, (float)1.0f);
        }
        if (this.headModel == null) {
            this.headModel = minecraft.getModelManager().getModel(HEAD_LOCATION);
        }
        if (((AbstractSynthesizerBlockEntity)crackingSynthesizer).isWorking()) {
            poseStack.translate(0.5, 0.0, 0.5);
            poseStack.mulPose(Axis.YP.rotationDegrees(-5.0f * ECRendererHelper.getClientTicks(partialTicks)));
            poseStack.translate(-0.5, 0.0, -0.5);
        }
        ECRendererHelper.renderModel(this.headModel, poseStack, bufferSource, crackingSynthesizer, light, overlay);
    }
}

