/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.synthesizer.cracking;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredHolder;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.synthesizer.AbstractSynthesizerBlockEntity;
import sirttas.elementalcraft.range.RangeRenderTimer;
import sirttas.elementalcraft.recipe.cracking.AbstractCrackingRecipe;
import sirttas.elementalcraft.recipe.cracking.CrackingRecipeInput;

public class AbstractCrackingSynthesizerBlockEntity<T extends AbstractCrackingRecipe>
extends AbstractSynthesizerBlockEntity {
    private final RangeRenderTimer rangeRenderTimer = new RangeRenderTimer();
    DeferredHolder<RecipeType<?>, RecipeType<T>> recipeType;

    public AbstractCrackingSynthesizerBlockEntity(Supplier<? extends BlockEntityType<?>> blockEntityType, Holder<IConfigurableBlockEntityProperties> propertiesHolder, DeferredHolder<RecipeType<?>, RecipeType<T>> recipeType, BlockPos pos, BlockState state) {
        super(blockEntityType, propertiesHolder, pos, state);
        this.recipeType = recipeType;
    }

    @Override
    protected int synthesizeElement() {
        return this.findRecipe().map(pair -> {
            AbstractCrackingRecipe recipe = (AbstractCrackingRecipe)((RecipeHolder)pair.getSecond()).value();
            this.level.setBlockAndUpdate((BlockPos)pair.getFirst(), recipe.result().defaultBlockState());
            return recipe.elementAmount();
        }).orElse(0);
    }

    private Optional<Pair<BlockPos, RecipeHolder<T>>> findRecipe() {
        RecipeManager recipeManager = this.level.getRecipeManager();
        RecipeType type = (RecipeType)this.recipeType.get();
        return this.getBlocksInRange().mapMulti((pos, downstream) -> {
            BlockState state = this.level.getBlockState(pos);
            if (state.isAir()) {
                return;
            }
            recipeManager.getRecipeFor(type, (RecipeInput)new CrackingRecipeInput(this.level.getBlockState(pos)), this.level).ifPresent(recipe -> downstream.accept(Pair.of((Object)pos, (Object)recipe)));
        }).findAny();
    }

    public boolean showsRange() {
        return this.rangeRenderTimer.showsRange();
    }

    public void startShowingRange() {
        this.rangeRenderTimer.startShowingRange();
    }
}

