/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.synthesizer;

import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.element.storage.single.SingleElementStorage;
import sirttas.elementalcraft.api.range.Range;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.api.rune.handler.RuneHandler;
import sirttas.elementalcraft.block.container.IContainerTopBlockEntity;
import sirttas.elementalcraft.block.entity.AbstractECBlockEntity;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.synthesizer.SynthesizerProperties;
import sirttas.elementalcraft.component.ECDataComponents;
import sirttas.elementalcraft.container.IElementStorageBlocKEntity;
import sirttas.elementalcraft.container.IRuneableBlockEntity;
import sirttas.elementalcraft.particle.ParticleHelper;
import sirttas.elementalcraft.range.RangeHelper;

public abstract class AbstractSynthesizerBlockEntity
extends AbstractECBlockEntity
implements IContainerTopBlockEntity,
IRuneableBlockEntity,
IElementStorageBlocKEntity,
IElementTypeProvider {
    protected final RuneHandler runeHandler;
    protected final int transferSpeed;
    protected final float synthesisMultiplier;
    protected final Range range;
    protected final SingleElementStorage bufferElementStorage;
    protected boolean working;
    private ISingleElementStorage containerCache;

    protected AbstractSynthesizerBlockEntity(Supplier<? extends BlockEntityType<?>> blockEntityType, Holder<IConfigurableBlockEntityProperties> propertiesHolder, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
        SynthesizerProperties properties = AbstractSynthesizerBlockEntity.getProperties(propertiesHolder);
        this.runeHandler = new RuneHandler(properties.maxRunes(), this::setChanged);
        this.transferSpeed = properties.transferSpeed();
        this.synthesisMultiplier = properties.synthesisMultiplier();
        this.range = properties.range().isBound() ? (Range)properties.range().value() : Range.DEFAULT;
        this.bufferElementStorage = new SingleElementStorage(properties.elementType(), properties.bufferCapacity(), this::setChanged);
        this.working = false;
    }

    public static void renderElementFlow(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        BlockEntityHelper.getBlockEntityAs((BlockGetter)level, pos, AbstractSynthesizerBlockEntity.class).filter(AbstractSynthesizerBlockEntity::isWorking).ifPresent(synthesizer -> ParticleHelper.createElementFlowParticle(synthesizer.getElementType(), level, Vec3.atCenterOf((Vec3i)pos.below()), Direction.DOWN, 1.0f, rand));
    }

    @NotNull
    private static SynthesizerProperties getProperties(Holder<IConfigurableBlockEntityProperties> propertiesHolder) {
        if (!propertiesHolder.isBound()) {
            throw new IllegalStateException("Properties not bound");
        }
        IConfigurableBlockEntityProperties value = (IConfigurableBlockEntityProperties)propertiesHolder.value();
        if (!(value instanceof SynthesizerProperties)) {
            throw new IllegalStateException("Invalid properties type");
        }
        SynthesizerProperties properties = (SynthesizerProperties)value;
        return properties;
    }

    protected void handleSynthesis() {
        boolean hasSynthesized;
        ISingleElementStorage container = this.getContainer();
        ElementType type = this.getElementType();
        if (container == null || type == ElementType.NONE) {
            return;
        }
        if (this.bufferElementStorage.getElementAmount() < this.transferSpeed) {
            this.bufferElementStorage.insertElement(this.synthesizeElement(), false);
            this.setChanged();
        }
        if (this.bufferElementStorage.getElementAmount() <= 0) {
            this.working = false;
            this.setChanged();
            return;
        }
        int synthesized = this.runeHandler.handleElementTransfer(this.bufferElementStorage, container, type, this.transferSpeed);
        boolean bl = hasSynthesized = synthesized > 0;
        if (hasSynthesized || this.working) {
            this.working = hasSynthesized;
            this.setChanged();
        }
    }

    protected abstract int synthesizeElement();

    public boolean isWorking() {
        return this.working;
    }

    public AABB getRange() {
        return this.runeHandler.getRange(this.range).move(this.worldPosition);
    }

    public Stream<BlockPos> getBlocksInRange() {
        return RangeHelper.getBlocksInAABB(this.getRange());
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        return this.bufferElementStorage.getElementType();
    }

    @Override
    public IElementStorage getElementStorage() {
        return this.bufferElementStorage;
    }

    @Override
    public ISingleElementStorage getContainer() {
        if (this.containerCache == null) {
            this.containerCache = IContainerTopBlockEntity.super.getContainer();
        }
        return this.containerCache;
    }

    @Override
    public RuneHandler getRuneHandler() {
        return this.runeHandler;
    }

    protected void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        if (compound.contains("element_storage")) {
            this.bufferElementStorage.deserializeNBT(provider, compound.getCompound("element_storage"));
        }
        if (compound.contains("rune_handler")) {
            IRuneHandler.readNBT(this.runeHandler, compound.getList("rune_handler", 8));
        }
        this.working = compound.getBoolean("working");
    }

    protected void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.put("element_storage", (Tag)this.bufferElementStorage.serializeNBT(provider));
        compound.put("rune_handler", (Tag)IRuneHandler.writeNBT(this.runeHandler));
        compound.putBoolean("working", this.working);
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.bufferElementStorage.setElementAmount((Integer)input.getOrDefault(ECDataComponents.ELEMENT_AMOUNT, (Object)0));
    }

    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(ECDataComponents.ELEMENT_AMOUNT, (Object)this.bufferElementStorage.getElementAmount());
    }

    @Deprecated
    public void removeComponentsFromTag(@NotNull CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("element_storage");
    }
}

