/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.synthesizer;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.INBTSerializable;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.synthesizer.AbstractSynthesizerBlockEntity;
import sirttas.elementalcraft.container.IContainerBlockEntity;

public abstract class AbstractContainerSynthesizerBlockEntity
extends AbstractSynthesizerBlockEntity
implements IContainerBlockEntity {
    protected AbstractContainerSynthesizerBlockEntity(Supplier<? extends BlockEntityType<?>> blockEntityType, Holder<IConfigurableBlockEntityProperties> propertiesHolder, BlockPos pos, BlockState state) {
        super(blockEntityType, propertiesHolder, pos, state);
    }

    @Override
    protected int synthesizeElement() {
        Container inventory = this.getInventory();
        ItemStack stack = inventory.getItem(0);
        if (stack.isEmpty()) {
            return 0;
        }
        int amount = this.getElementAmountForStack(stack);
        if (amount <= 0) {
            return 0;
        }
        if (stack.hasCraftingRemainingItem()) {
            inventory.setItem(0, stack.getCraftingRemainingItem());
        } else if (!stack.isEmpty()) {
            stack.shrink(1);
            if (stack.isEmpty()) {
                inventory.setItem(0, stack.getCraftingRemainingItem());
            }
        }
        return amount;
    }

    protected abstract int getElementAmountForStack(ItemStack var1);

    @Override
    public void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        Container inv = this.getInventory();
        if (inv instanceof INBTSerializable) {
            INBTSerializable nbtInv = (INBTSerializable)inv;
            if (compound.contains("inventory")) {
                nbtInv.deserializeNBT(provider, compound.get("inventory"));
            }
        }
    }

    @Override
    public void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        Container inv = this.getInventory();
        if (inv instanceof INBTSerializable) {
            INBTSerializable nbtInv = (INBTSerializable)inv;
            compound.put("inventory", nbtInv.serializeNBT(provider));
        }
    }
}

