/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.spelldesk;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.block.spelldesk.SpellDeskMenu;

public class SpellDeskScreen
extends AbstractContainerScreen<SpellDeskMenu>
implements MenuAccess<SpellDeskMenu> {
    private static final ResourceLocation SPELL_DESK_GUI_TEXTURE = ElementalCraftApi.createRL("textures/gui/container/spell_desk.png");
    private Button previous;
    private Button next;

    public SpellDeskScreen(SpellDeskMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
    }

    protected void init() {
        super.init();
        this.previous = Button.builder((Component)Component.literal((String)"<"), b -> ((SpellDeskMenu)this.menu).previousPage()).pos(this.leftPos + 107, this.topPos + 13).size(10, 20).build();
        this.next = Button.builder((Component)Component.literal((String)">"), b -> ((SpellDeskMenu)this.menu).nextPage()).pos(this.leftPos + 151, this.topPos + 13).size(10, 20).build();
        this.addRenderableOnly((Renderable)this.previous);
        this.addRenderableOnly((Renderable)this.next);
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        int page = ((SpellDeskMenu)this.menu).getPage();
        int pageCount = ((SpellDeskMenu)this.menu).getPageCount();
        this.previous.active = page > 0;
        this.next.active = page < pageCount - 1;
        MutableComponent pages = Component.literal((String)String.format("%d / %d", page + 1, pageCount));
        FormattedCharSequence formattedCharSequence = pages.getVisualOrderText();
        float f = (float)(this.leftPos + 136) - (float)this.font.width((FormattedText)pages) / 2.0f;
        float f2 = this.topPos + 23;
        Objects.requireNonNull(this.font);
        guiGraphics.drawString(this.font, formattedCharSequence, f, f2 - 9.0f / 2.0f, 0x404040, false);
    }

    protected void renderBg(@Nonnull GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(SPELL_DESK_GUI_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }
}

