/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.spelldesk;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.container.menu.AbstractECMenu;
import sirttas.elementalcraft.container.menu.ECMenus;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.recipe.ECRecipeTypes;
import sirttas.elementalcraft.recipe.SpellCraftRecipe;
import sirttas.elementalcraft.tag.ECTags;

public class SpellDeskMenu
extends AbstractECMenu {
    private final Container input;
    private final Container output;
    private final Level level;
    private final DataSlot page = DataSlot.standalone();
    private final DataSlot pageCount = DataSlot.standalone();
    private List<ItemStack> stacks;

    public SpellDeskMenu(int id, Inventory player) {
        super(ECMenus.SPELL_DESK, id);
        this.level = player.player.level();
        this.input = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 1);
        this.output = new SimpleContainer(6);
        this.stacks = Collections.emptyList();
        this.addSlot(new InputSlot(this, 0, 32, 35, s -> s.is((Item)ECItems.SCROLL_PAPER.get())));
        this.addSlot(new InputSlot(this, 1, 23, 53, s -> s.is(Tags.Items.GEMS)));
        this.addSlot(new InputSlot(this, 2, 41, 53, s -> s.is(ECTags.Items.CRYSTALS)));
        this.addSlot(new OutputSlot(0, 108, 35));
        this.addSlot(new OutputSlot(1, 126, 35));
        this.addSlot(new OutputSlot(2, 144, 35));
        this.addSlot(new OutputSlot(3, 108, 53));
        this.addSlot(new OutputSlot(4, 126, 53));
        this.addSlot(new OutputSlot(5, 144, 53));
        this.addPlayerSlots(player, 84);
        this.addDataSlot(this.page);
        this.addDataSlot(this.pageCount);
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            ItemStack stack = slotStack.copy();
            if (index < 3) {
                if (!this.moveItemStackTo(slotStack, 9, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else {
                if (index < 9) {
                    if (!this.moveItemStackTo(slotStack.copy(), 9, this.slots.size(), true)) {
                        return ItemStack.EMPTY;
                    }
                    slot.onTake(player, slotStack);
                    return ItemStack.EMPTY;
                }
                if (!this.moveItemStackTo(slotStack, 0, 3, false)) {
                    return ItemStack.EMPTY;
                }
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            return stack;
        }
        return ItemStack.EMPTY;
    }

    private void updateRecipeList(Level level) {
        RecipeInput recipeInput = new RecipeInput(){

            @NotNull
            public ItemStack getItem(int slot) {
                return SpellDeskMenu.this.input.getItem(slot);
            }

            public int size() {
                return SpellDeskMenu.this.input.getContainerSize();
            }
        };
        this.stacks = level.getRecipeManager().getRecipesFor((RecipeType)ECRecipeTypes.SPELL_CRAFT.get(), recipeInput, level).stream().map(arg_0 -> SpellDeskMenu.lambda$updateRecipeList$3(recipeInput, level, arg_0)).toList();
        this.page.set(0);
        this.pageCount.set(Math.max(1, (int)Math.ceil((double)this.stacks.size() / 6.0)));
        this.setOutput();
    }

    private void setOutput() {
        this.output.clearContent();
        int size = Math.min(this.stacks.size(), 6);
        int index = this.page.get() * 6;
        for (int i = 0; i < size; ++i) {
            this.output.setItem(i, this.stacks.get(i + index));
        }
        this.broadcastChanges();
    }

    public void slotsChanged(@Nonnull Container container) {
        this.updateRecipeList(this.level);
    }

    @Override
    public void removed(@Nonnull Player player) {
        super.removed(player);
        this.clearContainer(player, this.input);
    }

    public int getPage() {
        return this.page.get();
    }

    public int getPageCount() {
        return this.pageCount.get();
    }

    public void nextPage() {
        this.page.set(Math.min(this.getPage() + 1, this.getPageCount() - 1));
        this.setOutput();
    }

    public void previousPage() {
        this.page.set(Math.max(this.getPage() - 1, 0));
        this.setOutput();
    }

    private static /* synthetic */ ItemStack lambda$updateRecipeList$3(1 recipeInput, Level level, RecipeHolder h) {
        return ((SpellCraftRecipe)h.value()).assemble(recipeInput, (HolderLookup.Provider)level.registryAccess());
    }

    private class InputSlot
    extends Slot {
        private final Predicate<ItemStack> predicate;

        public InputSlot(SpellDeskMenu spellDeskMenu, int index, int xPosition, int yPosition, Predicate<ItemStack> predicate) {
            super(spellDeskMenu.input, index, xPosition, yPosition);
            this.predicate = predicate;
        }

        public boolean mayPlace(@Nonnull ItemStack stack) {
            return this.predicate.test(stack);
        }
    }

    private class OutputSlot
    extends Slot {
        public OutputSlot(int index, int xPosition, int yPosition) {
            super(SpellDeskMenu.this.output, index, xPosition, yPosition);
        }

        public boolean mayPlace(@Nonnull ItemStack stack) {
            return false;
        }

        public void onTake(@Nonnull Player player, @Nonnull ItemStack stack) {
            this.checkTakeAchievements(stack);
            for (int i = 0; i < SpellDeskMenu.this.input.getContainerSize(); ++i) {
                SpellDeskMenu.this.input.removeItem(i, 1);
            }
            SpellDeskMenu.this.updateRecipeList(player.level());
        }
    }
}

