/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.spelldesk;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.spelldesk.SpellDeskMenu;

public class SpellDeskBlock
extends HorizontalDirectionalBlock {
    public static final String NAME = "spell_desk";
    public static final MapCodec<SpellDeskBlock> CODEC = SpellDeskBlock.simpleCodec(SpellDeskBlock::new);
    private static final VoxelShape BASE_1 = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
    private static final VoxelShape BASE_2 = Block.box((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0);
    private static final VoxelShape PILAR = Block.box((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0);
    private static final VoxelShape PLATE_WEST_1 = Block.box((double)1.0, (double)8.0, (double)2.0, (double)6.0, (double)10.0, (double)14.0);
    private static final VoxelShape PLATE_WEST_2 = Block.box((double)4.0, (double)10.0, (double)2.0, (double)11.0, (double)12.0, (double)14.0);
    private static final VoxelShape PLATE_WEST_3 = Block.box((double)9.0, (double)12.0, (double)2.0, (double)15.0, (double)14.0, (double)14.0);
    private static final VoxelShape PLATE_EAST_1 = Block.box((double)10.0, (double)8.0, (double)2.0, (double)15.0, (double)10.0, (double)14.0);
    private static final VoxelShape PLATE_EAST_2 = Block.box((double)5.0, (double)10.0, (double)2.0, (double)12.0, (double)12.0, (double)14.0);
    private static final VoxelShape PLATE_EAST_3 = Block.box((double)1.0, (double)12.0, (double)2.0, (double)7.0, (double)14.0, (double)14.0);
    private static final VoxelShape PLATE_NORTH_1 = Block.box((double)2.0, (double)8.0, (double)1.0, (double)14.0, (double)10.0, (double)6.0);
    private static final VoxelShape PLATE_NORTH_2 = Block.box((double)2.0, (double)10.0, (double)4.0, (double)14.0, (double)12.0, (double)11.0);
    private static final VoxelShape PLATE_NORTH_3 = Block.box((double)2.0, (double)12.0, (double)9.0, (double)14.0, (double)14.0, (double)15.0);
    private static final VoxelShape PLATE_SOUTH_1 = Block.box((double)2.0, (double)8.0, (double)10.0, (double)14.0, (double)10.0, (double)15.0);
    private static final VoxelShape PLATE_SOUTH_2 = Block.box((double)2.0, (double)10.0, (double)5.0, (double)14.0, (double)12.0, (double)12.0);
    private static final VoxelShape PLATE_SOUTH_3 = Block.box((double)2.0, (double)12.0, (double)1.0, (double)14.0, (double)14.0, (double)7.0);
    private static final VoxelShape MAIN_SHAPE = Shapes.or((VoxelShape)BASE_1, (VoxelShape[])new VoxelShape[]{BASE_2, PILAR});
    private static final VoxelShape NORTH_SHAPE = Shapes.or((VoxelShape)MAIN_SHAPE, (VoxelShape[])new VoxelShape[]{PLATE_NORTH_1, PLATE_NORTH_2, PLATE_NORTH_3});
    private static final VoxelShape SOUTH_SHAPE = Shapes.or((VoxelShape)MAIN_SHAPE, (VoxelShape[])new VoxelShape[]{PLATE_SOUTH_1, PLATE_SOUTH_2, PLATE_SOUTH_3});
    private static final VoxelShape WEST_SHAPE = Shapes.or((VoxelShape)MAIN_SHAPE, (VoxelShape[])new VoxelShape[]{PLATE_WEST_1, PLATE_WEST_2, PLATE_WEST_3});
    private static final VoxelShape EAST_SHAPE = Shapes.or((VoxelShape)MAIN_SHAPE, (VoxelShape[])new VoxelShape[]{PLATE_EAST_1, PLATE_EAST_2, PLATE_EAST_3});
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public SpellDeskBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    protected MapCodec<SpellDeskBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> container) {
        container.add(new Property[]{FACING});
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            default -> MAIN_SHAPE;
        };
    }

    @Nonnull
    protected ItemInteractionResult useItemOn(@Nonnull ItemStack stack, @Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        player.openMenu((MenuProvider)new ContainerProvider());
        return ItemInteractionResult.CONSUME;
    }

    private class ContainerProvider
    implements MenuProvider {
        private ContainerProvider() {
        }

        public AbstractContainerMenu createMenu(int id, @Nonnull Inventory inventory, @Nonnull Player player) {
            return new SpellDeskMenu(id, inventory);
        }

        @Nonnull
        public Component getDisplayName() {
            return Component.translatable((String)SpellDeskBlock.this.getDescriptionId());
        }
    }
}

