/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source.trait.holder;

import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.common.util.INBTSerializable;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.source.trait.SourceTrait;
import sirttas.elementalcraft.api.source.trait.holder.ISourceTraitHolder;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.block.source.trait.SourceTraitHelper;
import sirttas.elementalcraft.block.source.trait.SourceTraits;

public class SourceTraitHolder
implements ISourceTraitHolder,
INBTSerializable<CompoundTag> {
    private final Map<Holder<SourceTrait>, ISourceTraitValue> traits = SourceTraits.createTraitMap();

    @Override
    public Map<Holder<SourceTrait>, ISourceTraitValue> getTraits() {
        return this.traits;
    }

    public void setTraits(Map<Holder<SourceTrait>, ISourceTraitValue> traits) {
        this.traits.clear();
        this.traits.putAll(traits);
    }

    public void initTraits(ServerLevelAccessor level, BlockPos pos, int luck) {
        if (!this.traits.isEmpty()) {
            return;
        }
        for (Holder holder : ElementalCraftApi.SOURCE_TRAIT_MANAGER.holders().toList()) {
            ISourceTraitValue value = ((SourceTrait)holder.value()).roll(level, pos, luck);
            if (value == null) continue;
            this.traits.put((Holder<SourceTrait>)holder, value);
        }
    }

    public void clear() {
        this.traits.clear();
    }

    public void load(@Nonnull CompoundTag compound) {
        SourceTraitHelper.loadTraits(compound, this.traits);
    }

    public CompoundTag save() {
        return SourceTraitHelper.saveTraits(this.traits);
    }

    public void deserializeNBT(@Nonnull HolderLookup.Provider provider, @Nonnull CompoundTag compound) {
        this.load(compound);
    }

    public CompoundTag serializeNBT(@Nonnull HolderLookup.Provider provider) {
        return this.save();
    }
}

