/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source.trait.holder;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.RecordBuilder;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import sirttas.dpanvil.api.data.DataManagerCodecs;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.source.trait.SourceTrait;
import sirttas.elementalcraft.api.source.trait.holder.ISourceTraitHolder;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.block.source.trait.SourceTraits;

public class ItemSourceTraitHolder
implements ISourceTraitHolder {
    private static final Codec<Holder<SourceTrait>> HOLDER_CODEC = DataManagerCodecs.holderCodec(ElementalCraftApi.SOURCE_TRAIT_MANAGER_KEY, SourceTrait.CODEC, (boolean)false);
    public static final Codec<ItemSourceTraitHolder> CODEC = new Codec<ItemSourceTraitHolder>(){

        public <T> DataResult<Pair<ItemSourceTraitHolder, T>> decode(DynamicOps<T> ops, T input) {
            return ops.getMap(input).setLifecycle(Lifecycle.stable()).flatMap(map -> {
                Object2ObjectArrayMap read = new Object2ObjectArrayMap();
                Stream.Builder failed = Stream.builder();
                DataResult result = map.entries().reduce(DataResult.success((Object)Unit.INSTANCE, (Lifecycle)Lifecycle.stable()), (arg_0, arg_1) -> 1.lambda$decode$5(ops, (Object2ObjectMap)read, failed, arg_0, arg_1), (r1, r2) -> r1.apply2stable((u1, u2) -> u1, r2));
                ImmutableMap elements = ImmutableMap.copyOf((Map)read);
                Object errors = ops.createMap(failed.build());
                return result.map(arg_0 -> 1.lambda$decode$8((Map)elements, arg_0)).setPartial((Object)elements).mapError(e -> e + " missed input: " + String.valueOf(errors));
            }).map(r -> {
                ItemSourceTraitHolder holder = new ItemSourceTraitHolder();
                holder.traits.putAll((Map<Holder<SourceTrait>, ISourceTraitValue>)r);
                return Pair.of((Object)holder, (Object)input);
            });
        }

        public <T> DataResult<T> encode(ItemSourceTraitHolder input, DynamicOps<T> ops, T prefix) {
            RecordBuilder builder = ops.mapBuilder();
            for (Map.Entry<Holder<SourceTrait>, ISourceTraitValue> entry : input.traits.entrySet()) {
                builder.add(HOLDER_CODEC.encodeStart(ops, entry.getKey()), ((SourceTrait)entry.getKey().value()).valueCodec().encodeStart(ops, (Object)entry.getValue()));
            }
            return builder.build(prefix);
        }

        private static /* synthetic */ Map lambda$decode$8(Map elements, Unit unit) {
            return elements;
        }

        private static /* synthetic */ DataResult lambda$decode$5(DynamicOps ops, Object2ObjectMap read, Stream.Builder failed, DataResult r, Pair pair) {
            ISourceTraitValue existingValue;
            DataResult key = HOLDER_CODEC.parse(ops, pair.getFirst());
            DataResult entryResult = key.flatMap(k -> ((SourceTrait)k.value()).valueCodec().parse(ops, pair.getSecond()).map(v -> Pair.of((Object)k, (Object)v)));
            Optional entry = entryResult.resultOrPartial();
            if (entry.isPresent() && (existingValue = (ISourceTraitValue)read.putIfAbsent((Object)((Holder)((Pair)entry.get()).getFirst()), (Object)((ISourceTraitValue)((Pair)entry.get()).getSecond()))) != null) {
                failed.add(pair);
                return r.apply2stable((u, p) -> u, DataResult.error(() -> "Duplicate entry for key: '" + String.valueOf(((Pair)entry.get()).getFirst()) + "'"));
            }
            if (entryResult.isError()) {
                failed.add(pair);
            }
            return r.apply2stable((u, p) -> u, entryResult);
        }
    };
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemSourceTraitHolder> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ItemSourceTraitHolder>(){

        @NotNull
        public ItemSourceTraitHolder decode(@NotNull RegistryFriendlyByteBuf buf) {
            int i = ByteBufCodecs.readCount((ByteBuf)buf, (int)Integer.MAX_VALUE);
            ItemSourceTraitHolder holder = new ItemSourceTraitHolder();
            for (int j = 0; j < i; ++j) {
                Holder k = ElementalCraftApi.SOURCE_TRAIT_MANAGER.getOrCreateHolder((ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buf));
                ISourceTraitValue v = (ISourceTraitValue)((SourceTrait)k.value()).valueStreamCodec().decode((Object)buf);
                holder.traits.put((Holder<SourceTrait>)k, v);
            }
            return holder;
        }

        public void encode(@NotNull RegistryFriendlyByteBuf buf, ItemSourceTraitHolder holder) {
            ByteBufCodecs.writeCount((ByteBuf)buf, (int)holder.traits.size(), (int)Integer.MAX_VALUE);
            holder.traits.forEach((k, v) -> {
                ResourceLocation.STREAM_CODEC.encode((Object)buf, (Object)ElementalCraftApi.SOURCE_TRAIT_MANAGER.getId(k));
                ((SourceTrait)k.value()).valueStreamCodec().encode((Object)buf, v);
            });
        }
    };
    public static final ItemSourceTraitHolder EMPTY = new ItemSourceTraitHolder();
    private final Map<Holder<SourceTrait>, ISourceTraitValue> traits = SourceTraits.createTraitMap();

    private ItemSourceTraitHolder() {
    }

    public static ItemSourceTraitHolder from(ISourceTraitHolder traitHolder) {
        return ItemSourceTraitHolder.from(traitHolder.getTraits());
    }

    public static ItemSourceTraitHolder from(Map<Holder<SourceTrait>, ISourceTraitValue> traits) {
        ItemSourceTraitHolder holder = new ItemSourceTraitHolder();
        holder.traits.putAll(traits);
        return holder;
    }

    @Override
    public Map<Holder<SourceTrait>, ISourceTraitValue> getTraits() {
        return Map.copyOf(this.traits);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equals(this.traits, ((ItemSourceTraitHolder)o).traits);
    }

    public int hashCode() {
        return Objects.hashCode(this.traits);
    }
}

