/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source.trait;

import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import sirttas.dpanvil.api.data.IDataManager;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.source.trait.SourceTrait;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;

public class SourceTraits {
    public static final ResourceKey<SourceTrait> ELEMENT_CAPACITY_KEY = SourceTraits.key("element_capacity");
    public static final Holder<SourceTrait> ELEMENT_CAPACITY = SourceTraits.holder(ELEMENT_CAPACITY_KEY);
    public static final ResourceKey<SourceTrait> DIURNAL_NOCTURNAL_KEY = SourceTraits.key("diurnal_nocturnal");
    public static final Holder<SourceTrait> DIURNAL_NOCTURNAL = SourceTraits.holder(DIURNAL_NOCTURNAL_KEY);
    public static final ResourceKey<SourceTrait> GENEROSITY_KEY = SourceTraits.key("generosity");
    public static final Holder<SourceTrait> GENEROSITY = SourceTraits.holder(GENEROSITY_KEY);
    public static final ResourceKey<SourceTrait> THRIFTINESS_KEY = SourceTraits.key("thriftiness");
    public static final Holder<SourceTrait> THRIFTINESS = SourceTraits.holder(THRIFTINESS_KEY);
    public static final ResourceKey<SourceTrait> FERTILITY_KEY = SourceTraits.key("fertility");
    public static final Holder<SourceTrait> FERTILITY = SourceTraits.holder(FERTILITY_KEY);

    private SourceTraits() {
    }

    @Nonnull
    public static SortedMap<Holder<SourceTrait>, ISourceTraitValue> createTraitMap() {
        return new TreeMap<Holder<SourceTrait>, ISourceTraitValue>(Comparator.comparingInt(SourceTraits::getOrder));
    }

    public static int getOrder(Holder<SourceTrait> trait) {
        return trait.isBound() ? ((SourceTrait)trait.value()).getOrder() : Integer.MAX_VALUE;
    }

    private static Holder<SourceTrait> holder(ResourceKey<SourceTrait> key) {
        return ElementalCraftApi.SOURCE_TRAIT_MANAGER.getOrCreateHolder(key);
    }

    private static ResourceKey<SourceTrait> key(String name) {
        return SourceTraits.key(ElementalCraftApi.createRL(name));
    }

    private static ResourceKey<SourceTrait> key(ResourceLocation name) {
        return IDataManager.createKey(ElementalCraftApi.SOURCE_TRAIT_MANAGER_KEY, (ResourceLocation)name);
    }
}

