/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source.trait;

import java.util.Map;
import java.util.SortedMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.source.trait.SourceTrait;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.block.source.trait.SourceTraits;

public class SourceTraitHelper {
    private SourceTraitHelper() {
    }

    @Nonnull
    public static Map<Holder<SourceTrait>, ISourceTraitValue> loadTraits(@Nullable CompoundTag tag) {
        SortedMap<Holder<SourceTrait>, ISourceTraitValue> traits = SourceTraits.createTraitMap();
        SourceTraitHelper.loadTraits(tag, traits);
        return traits;
    }

    public static void loadTraits(@Nullable CompoundTag tag, @Nonnull Map<Holder<SourceTrait>, ISourceTraitValue> traits) {
        traits.clear();
        if (tag != null) {
            for (String name : tag.getAllKeys()) {
                ISourceTraitValue value;
                Holder trait = ElementalCraftApi.SOURCE_TRAIT_MANAGER.getOrCreateHolder(ResourceLocation.parse((String)name));
                if (!trait.isBound() || (value = ((SourceTrait)trait.value()).load(tag.get(name))) == null) continue;
                traits.put((Holder<SourceTrait>)trait, value);
            }
        }
    }

    @Nonnull
    public static CompoundTag saveTraits(@Nonnull Map<Holder<SourceTrait>, ISourceTraitValue> traits) {
        CompoundTag traitTag = new CompoundTag();
        traits.forEach((key, value) -> {
            SourceTrait trait;
            Tag tag;
            if (key.isBound() && (tag = (trait = (SourceTrait)key.value()).save((ISourceTraitValue)value)) != null) {
                traitTag.put(trait.getId().toString(), tag);
            }
        });
        return traitTag;
    }

    public static Map<Holder<SourceTrait>, ISourceTraitValue> breed(@Nonnull RandomSource random, float luck, Map<Holder<SourceTrait>, ISourceTraitValue> map1, Map<Holder<SourceTrait>, ISourceTraitValue> map2) {
        SortedMap<Holder<SourceTrait>, ISourceTraitValue> traits = SourceTraits.createTraitMap();
        for (Holder holder : ElementalCraftApi.SOURCE_TRAIT_MANAGER.holders().toList()) {
            ISourceTraitValue value = ((SourceTrait)holder.value()).breed(random, luck, map1.get(holder), map2.get(holder));
            if (value == null) continue;
            traits.put((Holder<SourceTrait>)holder, value);
        }
        return traits;
    }
}

