/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source.breeder.pedestal;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.capability.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.api.rune.handler.RuneHandler;
import sirttas.elementalcraft.api.source.trait.holder.ISourceTraitHolder;
import sirttas.elementalcraft.block.entity.AbstractIERBlockEntity;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.source.breeder.pedestal.SourceBreederPedestalContainer;
import sirttas.elementalcraft.block.source.breeder.pedestal.SourceBreederPedestalElementStorage;
import sirttas.elementalcraft.component.ECDataComponents;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.container.SingleItemContainer;
import sirttas.elementalcraft.item.source.receptacle.ReceptacleHelper;
import sirttas.elementalcraft.recipe.input.SingleItemSingleElementRecipeInput;

public class SourceBreederPedestalBlockEntity
extends AbstractIERBlockEntity
implements IElementTypeProvider {
    private final SourceBreederPedestalElementStorage elementStorage = new SourceBreederPedestalElementStorage(this);
    private final SingleItemContainer inventory = new SourceBreederPedestalContainer(this::setChanged);
    private final RuneHandler runeHandler;

    public SourceBreederPedestalBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.SOURCE_BREEDER_PEDESTAL, pos, state);
        this.runeHandler = new RuneHandler((Integer)ECConfig.SERVER.sourceBreederPedestalMaxRunes.get(), this::setChanged);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SourceBreederPedestalBlockEntity pedestal) {
        pedestal.elementStorage.refreshElement();
    }

    @Override
    @Nonnull
    public ISingleElementStorage getElementStorage() {
        return this.elementStorage;
    }

    @Override
    public IRuneHandler getRuneHandler() {
        return this.runeHandler;
    }

    @Override
    @Nonnull
    public Container getInventory() {
        return this.inventory;
    }

    @Nullable
    public ISourceTraitHolder getTraitHolder() {
        ItemStack receptacle = this.getReceptacle();
        if (receptacle.isEmpty()) {
            return null;
        }
        return (ISourceTraitHolder)receptacle.getCapability(ElementalCraftCapabilities.SourceTrait.ITEM, null);
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        return ReceptacleHelper.getElementType(this.getReceptacle());
    }

    public ItemStack getReceptacle() {
        return this.inventory.getItem(0);
    }

    public boolean hasSource() {
        return !this.getReceptacle().isEmpty();
    }

    @NotNull
    public SingleItemSingleElementRecipeInput createRecipeInput() {
        return new SingleItemSingleElementRecipeInput(this.getInventory().getItem(0), this.getElementType(), this.getElementStorage().getElementAmount());
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.elementStorage.setElementAmount((Integer)input.getOrDefault(ECDataComponents.ELEMENT_AMOUNT, (Object)0));
    }

    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(ECDataComponents.ELEMENT_AMOUNT, (Object)this.elementStorage.getElementAmount());
    }

    @Deprecated
    public void removeComponentsFromTag(@NotNull CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("element_storage");
    }
}

