/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source.breeder.pedestal;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.AbstractECContainerBlock;
import sirttas.elementalcraft.block.WaterLoggingHelper;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.source.breeder.pedestal.SourceBreederPedestalBlockEntity;

public class SourceBreederPedestalBlock
extends AbstractECContainerBlock
implements SimpleWaterloggedBlock {
    public static final String NAME = "source_breeder_pedestal";
    public static final MapCodec<SourceBreederPedestalBlock> CODEC = SourceBreederPedestalBlock.simpleCodec(SourceBreederPedestalBlock::new);
    private static final VoxelShape BASE_1 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape BASE_2 = Block.box((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)7.0, (double)14.0);
    private static final VoxelShape BASE_3 = Block.box((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    private static final VoxelShape BASE_4 = Block.box((double)1.0, (double)9.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0);
    private static final VoxelShape PIPE_1 = Block.box((double)1.0, (double)2.0, (double)1.0, (double)3.0, (double)7.0, (double)3.0);
    private static final VoxelShape PIPE_2 = Block.box((double)13.0, (double)2.0, (double)1.0, (double)15.0, (double)7.0, (double)3.0);
    private static final VoxelShape PIPE_3 = Block.box((double)1.0, (double)2.0, (double)13.0, (double)3.0, (double)7.0, (double)15.0);
    private static final VoxelShape PIPE_4 = Block.box((double)13.0, (double)2.0, (double)13.0, (double)15.0, (double)7.0, (double)15.0);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)BASE_1, (VoxelShape[])new VoxelShape[]{BASE_2, BASE_3, BASE_4, PIPE_1, PIPE_2, PIPE_3, PIPE_4});

    public SourceBreederPedestalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<SourceBreederPedestalBlock> codec() {
        return CODEC;
    }

    @Nullable
    public <U extends BlockEntity> BlockEntityTicker<U> getTicker(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<U> type) {
        return SourceBreederPedestalBlock.createECTicker(level, type, ECBlockEntityTypes.SOURCE_BREEDER_PEDESTAL, SourceBreederPedestalBlockEntity::tick);
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    @Nonnull
    protected ItemInteractionResult useItemOn(@Nonnull ItemStack stack, @Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        return this.onSingleSlotActivated(stack, level, pos, player, hand);
    }

    @Nullable
    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new SourceBreederPedestalBlockEntity(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(WaterLoggingHelper.isPlacedInWater(context)));
    }

    @Nonnull
    public FluidState getFluidState(@Nonnull BlockState state) {
        return WaterLoggingHelper.isWaterlogged(state) ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }
}

