/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source.breeder;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.BooleanUtils;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.entity.renderer.SingleItemRenderer;
import sirttas.elementalcraft.block.source.SourceRendererHelper;
import sirttas.elementalcraft.block.source.breeder.SourceBreederBlockEntity;
import sirttas.elementalcraft.block.source.breeder.pedestal.SourceBreederPedestalBlock;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.item.source.receptacle.ReceptacleHelper;
import sirttas.elementalcraft.renderer.ECRendererHelper;
import sirttas.elementalcraft.tag.ECTags;

public class SourceBreederRenderer
extends SingleItemRenderer<SourceBreederBlockEntity> {
    private final BlockState pedestalState = ((SourceBreederPedestalBlock)((Object)ECBlocks.SOURCE_BREEDER_PEDESTAL.get())).defaultBlockState();

    public SourceBreederRenderer() {
        super(new Vec3(0.5, 1.0, 0.5));
    }

    @Override
    public void render(@Nonnull SourceBreederBlockEntity breeder, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        this.renderPedestalShadow(breeder, poseStack, buffer);
        ItemStack stack = breeder.getInventory().getItem(0);
        poseStack.translate(0.0f, 1.0f, 0.0f);
        if (stack.is(ECTags.Items.FULL_RECEPTACLES)) {
            ECRendererHelper.renderRunes(poseStack, buffer, breeder.getRuneHandler(), ECRendererHelper.getClientTicks(partialTicks), light, overlay);
            ElementType type = ReceptacleHelper.getElementType(stack);
            if (type == ElementType.NONE) {
                return;
            }
            poseStack.translate(0.0f, 1.0f, 0.0f);
            SourceRendererHelper.renderSource(poseStack, buffer, partialTicks, light, overlay, type, 1.0f);
            return;
        }
        super.render(breeder, partialTicks, poseStack, buffer, light, overlay);
    }

    private void renderPedestalShadow(@Nonnull SourceBreederBlockEntity breeder, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer) {
        List<Direction> directions;
        if (BooleanUtils.isTrue((Boolean)((Boolean)ECConfig.CLIENT.renderPedestalShadow.get())) && (directions = breeder.getPedestalsDirections()).size() < 2) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (directions.contains(direction)) continue;
                poseStack.pushPose();
                poseStack.translate((double)direction.getStepX() * 2.0, 0.0, (double)direction.getStepZ() * 2.0);
                ECRendererHelper.renderGhost(this.pedestalState, poseStack, buffer, breeder.getLevel(), breeder.getBlockPos().relative(direction, 2));
                poseStack.popPose();
            }
        }
    }
}

