/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source.breeder;

import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.capability.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.api.source.trait.holder.ISourceTraitHolder;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.entity.crafting.AbstractECCraftingBlockEntity;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.retriever.RetrieverBlock;
import sirttas.elementalcraft.block.source.breeder.SourceBreederContainer;
import sirttas.elementalcraft.block.source.breeder.pedestal.SourceBreederPedestalBlockEntity;
import sirttas.elementalcraft.block.source.trait.SourceTraitHelper;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.item.source.receptacle.ReceptacleHelper;
import sirttas.elementalcraft.particle.ParticleHelper;
import sirttas.elementalcraft.recipe.source.breeding.SourceBreedingRecipe;
import sirttas.elementalcraft.recipe.source.breeding.SourceBreedingRecipeInput;
import sirttas.elementalcraft.tag.ECTags;

public class SourceBreederBlockEntity
extends AbstractECCraftingBlockEntity<SourceBreedingRecipeInput, SourceBreedingRecipe>
implements IElementTypeProvider {
    public static final ResourceKey<IConfigurableBlockEntityProperties> PROPERTIES_KEY = IConfigurableBlockEntityProperties.createKey("source_breeder");
    private static final Holder<IConfigurableBlockEntityProperties> PROPERTIES = ElementalCraft.CONFIGURABLE_BLOCK_ENTITY_PROPERTIES_MANAGER.getOrCreateHolder(PROPERTIES_KEY);
    private final SourceBreederContainer container;
    private final Map<Direction, PedestalWrapper> pedestalWrappers;
    private final int baseCost;

    public SourceBreederBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.SOURCE_BREEDER, PROPERTIES, pos, state);
        this.baseCost = (Integer)ECConfig.SERVER.sourceBreedingBaseCost.get();
        this.container = new SourceBreederContainer(this::setChanged);
        this.pedestalWrappers = new EnumMap<Direction, PedestalWrapper>(Direction.class);
        this.pedestalWrappers.put(Direction.NORTH, new PedestalWrapper(Direction.NORTH));
        this.pedestalWrappers.put(Direction.SOUTH, new PedestalWrapper(Direction.SOUTH));
        this.pedestalWrappers.put(Direction.WEST, new PedestalWrapper(Direction.WEST));
        this.pedestalWrappers.put(Direction.EAST, new PedestalWrapper(Direction.EAST));
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SourceBreederBlockEntity breeder) {
        breeder.refreshPedestals();
        if (!breeder.isPowered()) {
            breeder.makeProgress();
        }
        AbstractECCraftingBlockEntity.tick(breeder);
    }

    private void refreshPedestals() {
        this.pedestalWrappers.forEach((d, w) -> {
            if (w.isRemoved()) {
                w.progress = 0;
                w.lookupPedestal();
            }
        });
    }

    @Override
    @Nonnull
    public Container getInventory() {
        return this.container;
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        ItemStack stack = this.container.getItem(0);
        if (!stack.is(ECTags.Items.SOURCE_SEEDS)) {
            return ElementType.NONE;
        }
        return ElementType.getElementType(stack);
    }

    private void makeProgress() {
        ElementType type = this.getElementType();
        if (type == ElementType.NONE || !this.isRecipeAvailable()) {
            this.resetProgress();
            return;
        }
        List<PedestalWrapper> activeWrappers = this.getActiveWrappers();
        activeWrappers.forEach(this::transfer);
        if (activeWrappers.stream().allMatch(w -> (float)w.progress >= w.getCost())) {
            this.process();
            this.resetProgress();
        }
    }

    private void resetProgress() {
        this.pedestalWrappers.values().forEach(w -> {
            w.progress = 0;
        });
    }

    private void transfer(PedestalWrapper wrapper) {
        float cost = wrapper.getCost();
        int oldProgress = wrapper.progress;
        float transferAmount = Math.min(this.getTransferSpeed(wrapper.pedestal), cost - (float)wrapper.progress);
        if (transferAmount > 0.0f) {
            float preservation = this.runeHandler.getBonus(Rune.BonusType.ELEMENT_PRESERVATION) + wrapper.pedestal.getRuneHandler().getBonus(Rune.BonusType.ELEMENT_PRESERVATION) + 1.0f;
            wrapper.progress = Math.round((float)wrapper.progress + (float)Math.max(1, wrapper.pedestal.getElementStorage().extractElement(Math.round(transferAmount / preservation), false)) * preservation);
        }
        if (this.level != null && this.level.isClientSide && wrapper.progress > oldProgress && this.level.random.nextDouble() < 0.2) {
            ParticleHelper.createElementFlowParticle(wrapper.getElementType(), this.level, Vec3.atCenterOf((Vec3i)wrapper.pedestal.getBlockPos()).relative(Direction.UP, 0.4), Vec3.atCenterOf((Vec3i)this.worldPosition).relative(Direction.UP, 1.7), this.level.random);
        } else if (this.level != null && !this.level.isClientSide) {
            this.setChanged();
        }
    }

    private float getTransferSpeed(SourceBreederPedestalBlockEntity pedestal) {
        return this.getTransferSpeed() * (this.runeHandler.getBonus(Rune.BonusType.SPEED) + pedestal.getRuneHandler().getBonus(Rune.BonusType.SPEED) + 1.0f);
    }

    private ItemStack breed(ElementType elementType, ISourceTraitHolder source1, ISourceTraitHolder source2) {
        return ReceptacleHelper.create(elementType, SourceTraitHelper.breed(this.level.random, this.runeHandler.getBonus(Rune.BonusType.LUCK), source1.getTraits(), source2.getTraits()));
    }

    @Override
    protected void assemble() {
        ElementType type = this.getElementType();
        List<PedestalWrapper> activeWrappers = this.getActiveWrappers();
        this.container.setItem(0, this.breed(type, activeWrappers.get(0).getTraitHolder(), activeWrappers.get(1).getTraitHolder()));
        for (PedestalWrapper pedestalWrapper : activeWrappers) {
            IElementStorage storage = (IElementStorage)pedestalWrapper.pedestal.getReceptacle().getCapability(ElementalCraftCapabilities.ElementStorage.ITEM);
            if (storage == null) continue;
            int drawn = Math.round((float)storage.getElementCapacity(type) * 0.25f) + 1;
            storage.extractElement(drawn, type, false);
            if (storage.getElementAmount(type) > 0) continue;
            pedestalWrapper.setPedestalInventory(ItemStack.EMPTY);
        }
    }

    @NotNull
    private List<PedestalWrapper> getActiveWrappers() {
        return this.pedestalWrappers.values().stream().filter(w -> !w.isEmpty()).toList();
    }

    @Override
    protected void retrieve() {
        RetrieverBlock.sendOutputToRetriever(this.level, this.worldPosition, this.getInventory(), 0);
        RetrieverBlock.sendOutputToRetriever(this.level, this.worldPosition.above(), this.getInventory(), 0);
    }

    @Override
    public void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putIntArray("progress", this.pedestalWrappers.entrySet().stream().sorted(Comparator.comparingInt(e -> ((Direction)e.getKey()).get2DDataValue())).mapToInt(e -> ((PedestalWrapper)e.getValue()).progress).toArray());
        compound.put("rune_handler", (Tag)IRuneHandler.writeNBT(this.runeHandler));
    }

    @Override
    public void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        if (compound.contains("rune_handler")) {
            IRuneHandler.readNBT(this.runeHandler, compound.getList("rune_handler", 8));
        }
    }

    public List<Direction> getPedestalsDirections() {
        return this.pedestalWrappers.entrySet().stream().filter(e -> !((PedestalWrapper)e.getValue()).isRemoved()).map(Map.Entry::getKey).toList();
    }

    @Override
    public boolean isRunning() {
        return this.getActiveWrappers().stream().anyMatch(w -> !w.isRemoved() && w.progress > 0);
    }

    @Override
    protected SourceBreedingRecipe lookupRecipe(@NotNull SourceBreedingRecipeInput recipeInput) {
        SourceBreedingRecipe recipe = new SourceBreedingRecipe();
        return recipe.matches(this.createRecipeInput(), this.level) ? recipe : null;
    }

    @Override
    @NotNull
    protected SourceBreedingRecipeInput createRecipeInput() {
        return new SourceBreedingRecipeInput(this.container.getItem(0), this.getElementType(), this.pedestalWrappers.values().stream().filter(w -> !w.isRemoved()).map(w -> w.pedestal.createRecipeInput()).toList());
    }

    private class PedestalWrapper
    implements IElementTypeProvider {
        private final Direction direction;
        private SourceBreederPedestalBlockEntity pedestal;
        private int progress;

        public PedestalWrapper(Direction direction) {
            this.direction = direction;
            this.pedestal = null;
            this.progress = 0;
        }

        public boolean isRemoved() {
            return this.pedestal == null || this.pedestal.isRemoved();
        }

        @Override
        @NotNull
        public ElementType getElementType() {
            return this.isRemoved() ? ElementType.NONE : this.pedestal.getElementType();
        }

        public void lookupPedestal() {
            SourceBreederPedestalBlockEntity p;
            BlockEntity te = SourceBreederBlockEntity.this.level != null ? SourceBreederBlockEntity.this.level.getBlockEntity(SourceBreederBlockEntity.this.worldPosition.relative(this.direction, 2)) : null;
            this.pedestal = te instanceof SourceBreederPedestalBlockEntity ? (p = (SourceBreederPedestalBlockEntity)te) : null;
        }

        public ISourceTraitHolder getTraitHolder() {
            return this.pedestal.getTraitHolder();
        }

        public float getCost() {
            return (float)SourceBreederBlockEntity.this.baseCost * this.getTraitHolder().getBreedingCost();
        }

        public void setPedestalInventory(ItemStack stack) {
            if (this.isRemoved()) {
                return;
            }
            this.pedestal.getInventory().setItem(0, stack);
            this.pedestal.setChanged();
        }

        public boolean isEmpty() {
            return this.isRemoved() || this.pedestal.getReceptacle().isEmpty();
        }
    }
}

