/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source.breeder;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.AbstractECContainerBlock;
import sirttas.elementalcraft.block.WaterLoggingHelper;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.shrine.AbstractPylonShrineBlock;
import sirttas.elementalcraft.block.source.breeder.SourceBreederBlockEntity;

public class SourceBreederBlock
extends AbstractECContainerBlock
implements SimpleWaterloggedBlock {
    public static final String NAME = "source_breeder";
    public static final MapCodec<SourceBreederBlock> CODEC = SourceBreederBlock.simpleCodec(SourceBreederBlock::new);
    private static final VoxelShape BASE_LOWER_1 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    private static final VoxelShape BASE_LOWER_2 = Block.box((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    private static final VoxelShape PIPE_LOWER_1 = Block.box((double)1.0, (double)3.0, (double)1.0, (double)3.0, (double)10.0, (double)3.0);
    private static final VoxelShape PIPE_LOWER_2 = Block.box((double)13.0, (double)3.0, (double)1.0, (double)15.0, (double)10.0, (double)3.0);
    private static final VoxelShape PIPE_LOWER_3 = Block.box((double)1.0, (double)3.0, (double)13.0, (double)3.0, (double)10.0, (double)15.0);
    private static final VoxelShape PIPE_LOWER_4 = Block.box((double)13.0, (double)3.0, (double)13.0, (double)15.0, (double)10.0, (double)15.0);
    private static final VoxelShape PIPE_LOWER_5 = Block.box((double)4.0, (double)8.0, (double)4.0, (double)6.0, (double)16.0, (double)6.0);
    private static final VoxelShape PIPE_LOWER_6 = Block.box((double)10.0, (double)8.0, (double)4.0, (double)12.0, (double)16.0, (double)6.0);
    private static final VoxelShape PIPE_LOWER_7 = Block.box((double)4.0, (double)8.0, (double)10.0, (double)6.0, (double)16.0, (double)12.0);
    private static final VoxelShape PIPE_LOWER_8 = Block.box((double)10.0, (double)8.0, (double)10.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape BASE_UPPER_1 = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0);
    private static final VoxelShape BASE_UPPER_2 = Block.box((double)5.0, (double)8.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0);
    private static final VoxelShape PIPE_UPPER_1 = Block.box((double)4.0, (double)2.0, (double)4.0, (double)6.0, (double)16.0, (double)6.0);
    private static final VoxelShape PIPE_UPPER_2 = Block.box((double)10.0, (double)2.0, (double)4.0, (double)12.0, (double)16.0, (double)6.0);
    private static final VoxelShape PIPE_UPPER_3 = Block.box((double)4.0, (double)2.0, (double)10.0, (double)6.0, (double)16.0, (double)12.0);
    private static final VoxelShape PIPE_UPPER_4 = Block.box((double)10.0, (double)2.0, (double)10.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape SHAPE_LOWER = Shapes.or((VoxelShape)BASE_LOWER_1, (VoxelShape[])new VoxelShape[]{BASE_LOWER_2, PIPE_LOWER_1, PIPE_LOWER_2, PIPE_LOWER_3, PIPE_LOWER_4, PIPE_LOWER_5, PIPE_LOWER_6, PIPE_LOWER_7, PIPE_LOWER_8});
    private static final VoxelShape SHAPE_UPPER = Shapes.or((VoxelShape)BASE_UPPER_1, (VoxelShape[])new VoxelShape[]{BASE_UPPER_2, PIPE_UPPER_1, PIPE_UPPER_2, PIPE_UPPER_3, PIPE_UPPER_4});

    public SourceBreederBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<SourceBreederBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER ? new SourceBreederBlockEntity(pos, state) : null;
    }

    @Nullable
    public <U extends BlockEntity> BlockEntityTicker<U> getTicker(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<U> type) {
        return SourceBreederBlock.createECTicker(level, type, ECBlockEntityTypes.SOURCE_BREEDER, SourceBreederBlockEntity::tick);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        level.setBlock(pos.above(), (BlockState)state.setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    @NotNull
    public BlockState playerWillDestroy(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        AbstractPylonShrineBlock.doubleHalfHarvest(level, pos, state, player);
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Nonnull
    public BlockState updateShape(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        return AbstractPylonShrineBlock.doubleHalfUpdateShape(state, facing, facingState, level, pos, () -> super.updateShape(state, facing, facingState, level, pos, facingPos));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED, BlockStateProperties.DOUBLE_BLOCK_HALF});
    }

    public boolean canSurvive(BlockState state, @Nonnull LevelReader level, @Nonnull BlockPos pos) {
        return state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER || level.getBlockState(pos.below()).is((Block)this);
    }

    @Nullable
    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        if (!AbstractPylonShrineBlock.canReplaceAboveBlock(context)) {
            return null;
        }
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(WaterLoggingHelper.isPlacedInWater(context)));
    }

    @Nonnull
    public FluidState getFluidState(@Nonnull BlockState state) {
        return WaterLoggingHelper.isWaterlogged(state) ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER ? SHAPE_LOWER : SHAPE_UPPER;
    }

    @Nonnull
    protected ItemInteractionResult useItemOn(@Nonnull ItemStack stack, @Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        if (state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.UPPER) {
            pos = pos.below();
        }
        return this.onSingleSlotActivated(stack, level, pos, player, hand);
    }
}

