/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source;

import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.world.level.Level;
import sirttas.elementalcraft.api.source.trait.SourceTrait;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.block.source.SourceBlockEntity;
import sirttas.elementalcraft.block.source.trait.SourceTraits;
import sirttas.elementalcraft.block.source.trait.holder.SourceTraitHolder;

public class SourceSourceTraitHolder
extends SourceTraitHolder {
    public final SourceBlockEntity source;

    public SourceSourceTraitHolder(@Nonnull SourceBlockEntity source) {
        this.source = source;
    }

    @Override
    public float getPreservationModifier() {
        return super.getPreservationModifier() * (this.source.isStabilized() ? 1.05f : 1.0f);
    }

    @Override
    public float getTraits(SourceTrait.Type type) {
        return (float)this.getTraits().entrySet().stream().mapToDouble(e -> {
            float value = ((ISourceTraitValue)e.getValue()).getValue(type);
            if (((Holder)e.getKey()).is(SourceTraits.DIURNAL_NOCTURNAL_KEY)) {
                Level level = this.source.getLevel();
                if (level == null || value == 0.0f || value == 1.0f) {
                    return 1.0;
                }
                if (level.isDay()) {
                    return value;
                }
                if (level.isNight()) {
                    return 1.0f / value;
                }
                return 1.0;
            }
            return value;
        }).reduce(1.0, (a, b) -> a * b);
    }
}

