/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.Material;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.renderer.ECRenderTypes;
import sirttas.elementalcraft.renderer.ECRendererHelper;

public class SourceRendererHelper {
    public static final Material OUTER = ECRendererHelper.getBlockMaterial("effect/source_outer");
    public static final Material MIDDLE = ECRendererHelper.getBlockMaterial("effect/source_middle");

    private SourceRendererHelper() {
    }

    public static void renderSource(@Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, float partialTicks, int light, int overlay, ElementType elementType, float ratio) {
        float r = elementType.getRed();
        float g = elementType.getGreen();
        float b = elementType.getBlue();
        float angle = -(ECRendererHelper.getClientTicks(partialTicks) % 360.0f);
        poseStack.pushPose();
        poseStack.translate(0.5, 0.3, 0.5);
        poseStack.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().camera.rotation());
        poseStack.scale(0.016f, 0.016f, 0.016f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(angle));
        poseStack.translate(-16.0f, -16.0f, 0.0f);
        ECRendererHelper.renderIcon(poseStack, buffer, 0.0f, 0.0f, OUTER, 32, 32, r, g, b, light, overlay);
        poseStack.translate(16.0f, 16.0f, 0.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(angle * 5.0f * ratio));
        poseStack.translate(-16.0, -16.0, -0.01);
        ECRendererHelper.renderIcon(poseStack, MIDDLE.buffer(buffer, ECRenderTypes::source), 0.0f, 0.0f, 32, 32, r, g, b, light, overlay);
        poseStack.popPose();
    }
}

