/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.source.SourceBlockEntity;
import sirttas.elementalcraft.block.source.SourceRendererHelper;
import sirttas.elementalcraft.client.model.ECModelHelper;
import sirttas.elementalcraft.renderer.ECRendererHelper;

public class SourceRenderer
implements BlockEntityRenderer<SourceBlockEntity> {
    public static final ModelResourceLocation STABILIZER_LOCATION = ECModelHelper.standalone("block/source_stabilizer");
    private BakedModel stabilizerModel;

    public void render(@Nonnull SourceBlockEntity source, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        Minecraft minecraft = Minecraft.getInstance();
        ElementType elementType = source.getElementType();
        float r = elementType.getRed();
        float g = elementType.getGreen();
        float b = elementType.getBlue();
        if (this.stabilizerModel == null) {
            this.stabilizerModel = minecraft.getModelManager().getModel(STABILIZER_LOCATION);
        }
        SourceRendererHelper.renderSource(poseStack, buffer, partialTicks, light, overlay, elementType, source.getRemainingRatio());
        if (source.isStabilized()) {
            poseStack.translate(0.5, 0.0, 0.5);
            poseStack.mulPose(Axis.YP.rotation(ECRendererHelper.getClientTicks(partialTicks) / 20.0f));
            poseStack.translate(-0.5, 0.0, -0.5);
            poseStack.translate(0.0, -0.25, 0.0);
            minecraft.getBlockRenderer().getModelRenderer().renderModel(poseStack.last(), buffer.getBuffer(RenderType.translucent()), source.getBlockState(), this.stabilizerModel, r, g, b, light, overlay, ECRendererHelper.getModelData(this.stabilizerModel, source), RenderType.translucent());
        }
    }
}

