/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source;

import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.single.SingleElementStorage;
import sirttas.elementalcraft.api.source.trait.holder.ISourceTraitHolder;
import sirttas.elementalcraft.block.source.SourceBlockEntity;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.item.ECItems;

public class SourceElementStorage
extends SingleElementStorage {
    public static final int DEFAULT_CAPACITY = 5000000;
    private final SourceBlockEntity source;

    public SourceElementStorage(SourceBlockEntity source) {
        super(ElementType.NONE, 5000000, source::setChanged);
        this.source = source;
        this.elementAmount = this.elementCapacity;
    }

    protected void setElementType(ElementType elementType) {
        this.elementType = elementType;
    }

    public SourceBlockEntity getSource() {
        return this.source;
    }

    @Override
    public int transferTo(IElementStorage other, ElementType type, float count, float multiplier) {
        ISourceTraitHolder traitHolder = this.source.getTraitHolder();
        return super.transferTo(other, type, count * traitHolder.getSpeedModifier(), multiplier * traitHolder.getPreservationModifier());
    }

    @Override
    public boolean canPipeInsert(ElementType elementType, Direction side) {
        return false;
    }

    @Override
    public boolean canPipeExtract(ElementType elementType, Direction side) {
        return false;
    }

    @Override
    public boolean doesRenderGauge(Player player) {
        return EntityHelper.handStream((LivingEntity)player).anyMatch(i -> i.is((Item)ECItems.SOURCE_ANALYSIS_GLASS.get()));
    }

    protected void setElementCapacity(int elementCapacity) {
        this.elementCapacity = elementCapacity;
    }
}

