/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.source.trait.holder.ISourceTraitHolder;
import sirttas.elementalcraft.block.entity.AbstractECBlockEntity;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.source.SourceElementStorage;
import sirttas.elementalcraft.block.source.SourceSourceTraitHolder;
import sirttas.elementalcraft.block.source.trait.holder.ItemSourceTraitHolder;
import sirttas.elementalcraft.component.ECDataComponents;
import sirttas.elementalcraft.container.IElementStorageBlocKEntity;

public class SourceBlockEntity
extends AbstractECBlockEntity
implements IElementTypeProvider,
IElementStorageBlocKEntity {
    private boolean stabilized = false;
    private final SourceElementStorage elementStorage = new SourceElementStorage(this);
    private final SourceSourceTraitHolder traitHolder;

    public SourceBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.SOURCE, pos, state);
        this.elementStorage.setElementType(ElementType.getElementType(state));
        this.traitHolder = new SourceSourceTraitHolder(this);
    }

    @Override
    @NotNull
    public ISingleElementStorage getElementStorage() {
        return this.elementStorage;
    }

    @NotNull
    public ISourceTraitHolder getTraitHolder() {
        return this.traitHolder;
    }

    public void setLevel(@NotNull Level level) {
        super.setLevel(level);
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.traitHolder.isEmpty()) {
            this.initTraits((ServerLevelAccessor)serverLevel, 0);
        }
    }

    private void initTraits(@Nonnull ServerLevelAccessor level, int luck) {
        if (this.elementStorage.getElementType() == ElementType.NONE) {
            this.elementStorage.setElementType(ElementType.getElementType(this.getBlockState()));
            this.setChanged();
        }
        this.traitHolder.initTraits(level, this.worldPosition, luck);
        this.refreshCapacity();
    }

    public void resetTraits(@Nonnull ServerLevelAccessor level, int luck) {
        this.traitHolder.clear();
        this.initTraits(level, luck);
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        return this.elementStorage.getElementType();
    }

    public float getRemainingRatio() {
        int capacity = this.elementStorage.getElementCapacity();
        if (capacity == 0) {
            return 0.0f;
        }
        return (float)this.elementStorage.getElementAmount() / (float)capacity;
    }

    public boolean isStabilized() {
        return this.stabilized;
    }

    public void setStabilized(boolean stabilized) {
        this.stabilized = stabilized;
        this.setChanged();
    }

    private void refreshCapacity() {
        int oldCapacity = this.elementStorage.getElementCapacity();
        int capacity = this.traitHolder.getCapacity();
        int amount = this.elementStorage.getElementAmount();
        this.elementStorage.setElementCapacity(capacity);
        if (amount <= 0 || amount >= oldCapacity || amount >= capacity) {
            this.elementStorage.setElementAmount(capacity);
        }
        this.setChanged();
    }

    public void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        if (compound.contains("element_storage")) {
            this.elementStorage.deserializeNBT(provider, compound.getCompound("element_storage"));
        }
        if (compound.contains("source_traits_holder")) {
            this.traitHolder.deserializeNBT(provider, compound.getCompound("source_traits_holder"));
        }
        this.stabilized = compound.getBoolean("stabilized");
        this.refreshCapacity();
    }

    public void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.put("element_storage", (Tag)this.elementStorage.serializeNBT(provider));
        compound.put("source_traits_holder", (Tag)this.traitHolder.serializeNBT(provider));
        compound.putBoolean("stabilized", this.stabilized);
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.elementStorage.setElementAmount((Integer)input.getOrDefault(ECDataComponents.ELEMENT_AMOUNT, (Object)0));
        this.traitHolder.setTraits(((ItemSourceTraitHolder)input.getOrDefault(ECDataComponents.SOURCE_TRAITS_HOLDER, (Object)ItemSourceTraitHolder.EMPTY)).getTraits());
    }

    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(ECDataComponents.ELEMENT_AMOUNT, (Object)this.elementStorage.getElementAmount());
        builder.set(ECDataComponents.SOURCE_TRAITS_HOLDER, (Object)ItemSourceTraitHolder.from(this.traitHolder));
    }

    @Deprecated
    public void removeComponentsFromTag(@NotNull CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("element_storage");
        tag.remove("source_traits_holder");
    }
}

