/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.source.trait.value.ISourceTraitValue;
import sirttas.elementalcraft.block.AbstractECEntityBlock;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.source.SourceBlockEntity;
import sirttas.elementalcraft.item.source.receptacle.ReceptacleItem;

public class SourceBlock
extends AbstractECEntityBlock
implements IElementTypeProvider {
    private static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    public static final String NAME = "source";
    public static final String NAME_FIRE = "fire_source";
    public static final String NAME_WATER = "water_source";
    public static final String NAME_EARTH = "earth_source";
    public static final String NAME_AIR = "air_source";
    public static final MapCodec<SourceBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(ElementType.forGetter(SourceBlock::getElementType), (App)SourceBlock.propertiesCodec()).apply((Applicative)instance, SourceBlock::new));
    private final ElementType elementType;

    public SourceBlock(ElementType elementType, BlockBehaviour.Properties properties) {
        super(properties);
        this.elementType = elementType;
    }

    @Override
    @NotNull
    public ElementType getElementType() {
        return this.elementType;
    }

    @NotNull
    protected MapCodec<SourceBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new SourceBlockEntity(pos, state);
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    @Nonnull
    public VoxelShape getCollisionShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return Shapes.empty();
    }

    public boolean canBeReplaced(@Nonnull BlockState state, @Nonnull BlockPlaceContext context) {
        return super.canBeReplaced(state, context) && BlockEntityHelper.getBlockEntityAs((BlockGetter)context.getLevel(), context.getClickedPos(), SourceBlockEntity.class).map(s -> !s.isStabilized()).orElse(true) != false;
    }

    @Override
    @Nonnull
    public RenderShape getRenderShape(@Nonnull BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext tooltipContext, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        Collection<ISourceTraitValue> traits = ReceptacleItem.getTraitHolder(stack).getTraits().values();
        if (traits.isEmpty()) {
            return;
        }
        for (ISourceTraitValue value : traits) {
            tooltip.add(value.getDescription());
        }
    }

    public static SourceBlock findSourceBlock(ElementType type) {
        return switch (type) {
            case ElementType.FIRE -> (SourceBlock)ECBlocks.FIRE_SOURCE.get();
            case ElementType.WATER -> (SourceBlock)ECBlocks.WATER_SOURCE.get();
            case ElementType.EARTH -> (SourceBlock)ECBlocks.EARTH_SOURCE.get();
            case ElementType.AIR -> (SourceBlock)ECBlocks.AIR_SOURCE.get();
            default -> throw new IllegalArgumentException("Invalid type: " + String.valueOf(type));
        };
    }
}

