/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.sorter;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import sirttas.elementalcraft.block.sorter.ISorterBlock;
import sirttas.elementalcraft.block.sorter.SorterBlockEntity;
import sirttas.elementalcraft.renderer.ECRendererHelper;

public class SorterRenderer
implements BlockEntityRenderer<SorterBlockEntity> {
    public void render(@Nonnull SorterBlockEntity sorter, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        HitResult mouseOver = Minecraft.getInstance().hitResult;
        boolean shiftKeyDown = Minecraft.getInstance().player.isShiftKeyDown();
        List<ItemStack> stacks = sorter.getStacks();
        if (mouseOver != null && mouseOver.getType() == HitResult.Type.BLOCK && !stacks.isEmpty()) {
            poseStack.pushPose();
            BlockHitResult result = (BlockHitResult)mouseOver;
            if (sorter.getBlockPos().equals((Object)result.getBlockPos())) {
                int i;
                int index = sorter.getIndex();
                Quaternionf rotation = result.getDirection().getRotation();
                Vector3f newPos = new Vector3f(0.0f, 0.125f, 0.0625f);
                poseStack.translate(0.5, 0.5, 0.5);
                rotation.transform(newPos);
                poseStack.translate(newPos.x(), newPos.y(), newPos.z());
                poseStack.mulPose(rotation);
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                poseStack.scale(0.5f, 0.5f, 0.5f);
                ECRendererHelper.renderItem(stacks.get(index), poseStack, buffer, light, overlay);
                poseStack.scale(0.5f, 0.5f, 0.5f);
                poseStack.pushPose();
                this.translate(poseStack, 0.5, shiftKeyDown);
                for (i = index - 1; i >= 0; --i) {
                    this.translate(poseStack, 0.5, shiftKeyDown);
                    ECRendererHelper.renderItem(stacks.get(i), poseStack, buffer, light, overlay);
                }
                poseStack.popPose();
                poseStack.pushPose();
                this.translate(poseStack, -0.5, shiftKeyDown);
                for (i = index + 1; i < stacks.size(); ++i) {
                    this.translate(poseStack, -0.5, shiftKeyDown);
                    ECRendererHelper.renderItem(stacks.get(i), poseStack, buffer, light, overlay);
                }
                poseStack.popPose();
            }
            poseStack.popPose();
        }
        this.renderRunes(sorter, partialTicks, poseStack, buffer, light, overlay);
    }

    private void renderRunes(SorterBlockEntity sorter, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        poseStack.translate(0.5f, 0.5f, 0.5f);
        BlockState state = sorter.getBlockState();
        Quaternionf rotation1 = ((Direction)state.getValue((Property)ISorterBlock.SOURCE)).getOpposite().getRotation();
        Quaternionf rotation2 = ((Direction)state.getValue((Property)ISorterBlock.TARGET)).getRotation();
        Quaternionf rotation = new Quaternionf(rotation1.x() + rotation2.x(), rotation1.y() + rotation2.y(), rotation1.z() + rotation2.z(), rotation1.w() + rotation2.w());
        rotation.normalize();
        poseStack.mulPose(rotation);
        poseStack.translate(-0.5f, -0.75f, -0.5f);
        ECRendererHelper.renderRunes(poseStack, buffer, sorter.getRuneHandler(), ECRendererHelper.getClientTicks(partialTicks), light, overlay);
    }

    private void translate(PoseStack matrixStack, double value, boolean sneeking) {
        if (sneeking) {
            matrixStack.translate(-value, 0.0, 0.0);
        } else {
            matrixStack.translate(0.0, value, 0.0);
        }
    }
}

