/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.sorter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.api.rune.handler.IRuneHandler;
import sirttas.elementalcraft.api.rune.handler.RuneHandler;
import sirttas.elementalcraft.block.entity.AbstractECBlockEntity;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.sorter.ISorterBlock;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.container.ECContainerHelper;
import sirttas.elementalcraft.tag.ECTags;

public class SorterBlockEntity
extends AbstractECBlockEntity {
    private final List<ItemStack> stacks = Lists.newArrayList();
    private int index = 0;
    private float tick = 0.0f;
    private boolean alwaysInsert = false;
    private final RuneHandler runeHandler;

    public SorterBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.SORTER, pos, state);
        this.runeHandler = new RuneHandler((Integer)ECConfig.SERVER.sorterMaxRunes.get(), this::setChanged);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, SorterBlockEntity sorter) {
        if (sorter.isPowered()) {
            return;
        }
        ProfilerFiller profiler = level.getProfiler();
        profiler.push("elementalcraft:sorter");
        float speed = sorter.runeHandler.getBonus(Rune.BonusType.SPEED) + 1.0f;
        int cooldown = (Integer)ECConfig.SERVER.sorterCooldown.get();
        sorter.tick += Math.min(speed, (float)cooldown * 64.0f);
        while (sorter.tick > (float)cooldown) {
            sorter.transfer();
            sorter.tick -= (float)cooldown;
        }
        profiler.pop();
    }

    public ItemInteractionResult addStack(ItemStack stack) {
        if (!this.stacks.isEmpty() && stack.isEmpty()) {
            this.stacks.clear();
            this.index = 0;
            this.setChanged();
            return ItemInteractionResult.SUCCESS;
        }
        if (this.stacks.size() < (Integer)ECConfig.SERVER.sorterMaxItem.get()) {
            ItemStack copy = stack.copy();
            copy.setCount(1);
            this.stacks.add(copy);
            this.setChanged();
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public List<ItemStack> getStacks() {
        return ImmutableList.copyOf(this.stacks);
    }

    @Nonnull
    public IRuneHandler getRuneHandler() {
        return this.runeHandler;
    }

    public int getIndex() {
        return this.index;
    }

    void transfer() {
        block4: {
            boolean isTargetingInstrument;
            IItemHandler targetInv;
            IItemHandler sourceInv;
            block3: {
                BlockState state = this.getBlockState();
                Direction source = (Direction)state.getValue((Property)ISorterBlock.SOURCE);
                Direction target = (Direction)state.getValue((Property)ISorterBlock.TARGET);
                sourceInv = ECContainerHelper.getItemHandlerAt((BlockGetter)this.level, this.worldPosition.relative(source), source.getOpposite());
                targetInv = ECContainerHelper.getItemHandlerAt((BlockGetter)this.level, this.worldPosition.relative(target), target.getOpposite());
                isTargetingInstrument = this.level.getBlockState(this.worldPosition.relative(target)).is(ECTags.Blocks.INSTRUMENTS);
                if (!this.stacks.isEmpty()) break block3;
                for (int i = 0; i < sourceInv.getSlots(); ++i) {
                    ItemStack stack = sourceInv.getStackInSlot(i).copy();
                    stack.setCount(1);
                    if (stack.isEmpty() || !this.doTransfer(sourceInv, targetInv, i, true)) continue;
                    this.doTransfer(sourceInv, targetInv, i, false);
                    return;
                }
                break block4;
            }
            if (!this.alwaysInsert && isTargetingInstrument && this.index <= 0 && !ECContainerHelper.isEmpty(targetInv)) break block4;
            ItemStack stack = this.stacks.get(this.index).copy();
            for (int i = 0; i < sourceInv.getSlots(); ++i) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)sourceInv.getStackInSlot(i)) || !this.doTransfer(sourceInv, targetInv, i, true)) continue;
                this.doTransfer(sourceInv, targetInv, i, false);
                ++this.index;
                if (this.index >= this.stacks.size()) {
                    this.index = 0;
                }
                return;
            }
        }
    }

    private boolean doTransfer(IItemHandler sourceInv, IItemHandler targetInv, int i, boolean simulate) {
        ItemStack extracted = sourceInv.extractItem(i, 1, simulate);
        if (extracted.isEmpty()) {
            return false;
        }
        ItemStack stack = ItemHandlerHelper.insertItem((IItemHandler)targetInv, (ItemStack)extracted, (boolean)simulate);
        if (!simulate) {
            this.setChanged();
        }
        return !stack.equals(extracted);
    }

    public void loadAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.readStacks(provider, compound.getList("stacks", 10));
        this.index = compound.getInt("index");
        if (this.index > this.stacks.size()) {
            this.index = 0;
        }
        this.alwaysInsert = compound.getBoolean("always_insert");
        if (compound.contains("rune_handler")) {
            IRuneHandler.readNBT(this.runeHandler, compound.getList("rune_handler", 8));
        }
    }

    private void readStacks(@Nonnull HolderLookup.Provider provider, ListTag listNbt) {
        this.stacks.clear();
        for (int i = 0; i < listNbt.size(); ++i) {
            ItemStack itemstack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)listNbt.getCompound(i));
            if (itemstack.isEmpty()) continue;
            this.stacks.add(itemstack);
        }
    }

    public void saveAdditional(@Nonnull CompoundTag compound, @Nonnull HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.put("stacks", (Tag)this.writeStacks(provider));
        compound.putInt("index", this.index);
        compound.putBoolean("always_insert", this.alwaysInsert);
        compound.put("rune_handler", (Tag)IRuneHandler.writeNBT(this.runeHandler));
    }

    private ListTag writeStacks(@Nonnull HolderLookup.Provider provider) {
        ListTag listTag = new ListTag();
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.isEmpty()) continue;
            listTag.add((Object)itemstack.save(provider));
        }
        return listTag;
    }
}

