/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.sorter;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.AbstractECEntityBlock;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.sorter.ISorterBlock;
import sirttas.elementalcraft.block.sorter.SorterBlockEntity;

public class SorterBlock
extends AbstractECEntityBlock
implements ISorterBlock {
    public static final String NAME = "sorter";
    public static final MapCodec<SorterBlock> CODEC = SorterBlock.simpleCodec(SorterBlock::new);
    private static final VoxelShape CORE_VOID = Shapes.or((VoxelShape)Block.box((double)5.0, (double)6.0, (double)6.0, (double)11.0, (double)10.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.box((double)6.0, (double)5.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0), Block.box((double)6.0, (double)6.0, (double)5.0, (double)10.0, (double)10.0, (double)11.0)});
    private static final VoxelShape CORE = Shapes.or((VoxelShape)Shapes.join((VoxelShape)Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), (VoxelShape)CORE_VOID, (BooleanOp)BooleanOp.ONLY_FIRST), (VoxelShape)Block.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0));

    public SorterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SOURCE, (Comparable)Direction.SOUTH)).setValue((Property)TARGET, (Comparable)Direction.NORTH));
    }

    @NotNull
    protected MapCodec<SorterBlock> codec() {
        return CODEC;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)SOURCE, (Comparable)direction.getOpposite())).setValue((Property)TARGET, (Comparable)direction);
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new SorterBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return SorterBlock.createECServerTicker(level, type, ECBlockEntityTypes.SORTER, SorterBlockEntity::serverTick);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> container) {
        container.add(new Property[]{SOURCE, TARGET});
    }

    @Override
    public VoxelShape getCoreShape(BlockState state) {
        return CORE;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter blockGetter, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        VoxelShape voxelShape;
        if (blockGetter instanceof Level) {
            Level level = (Level)blockGetter;
            if (level.isClientSide) {
                voxelShape = this.getShape(state, pos, Minecraft.getInstance().hitResult);
                return voxelShape;
            }
        }
        voxelShape = this.getCurrentShape(state);
        return voxelShape;
    }

    @Nonnull
    public VoxelShape getCollisionShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return this.getCurrentShape(state);
    }

    @Nonnull
    protected ItemInteractionResult useItemOn(@Nonnull ItemStack stack, @Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        VoxelShape shape = this.getShape(state, pos, (HitResult)hit);
        if (CORE.equals(shape)) {
            return BlockEntityHelper.getBlockEntityAs((BlockGetter)level, pos, SorterBlockEntity.class).map(sorter -> sorter.addStack(player.getItemInHand(hand))).orElse(ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION);
        }
        return this.moveIO(state, level, pos, hit, shape);
    }
}

