/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.sorter;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import sirttas.elementalcraft.block.shape.ECShapes;
import sirttas.elementalcraft.block.shape.ShapeHelper;

public interface ISorterBlock {
    public static final DirectionProperty SOURCE = DirectionProperty.create((String)"source", (Direction[])Direction.values());
    public static final DirectionProperty TARGET = DirectionProperty.create((String)"target", (Direction[])Direction.values());

    default public VoxelShape getSourceShape(BlockState state) {
        return ECShapes.sourceShape((Direction)state.getValue((Property)SOURCE));
    }

    default public VoxelShape getTargetShape(BlockState state) {
        return ECShapes.targetShape((Direction)state.getValue((Property)TARGET));
    }

    public VoxelShape getCoreShape(BlockState var1);

    default public VoxelShape getCurrentShape(BlockState state) {
        return Shapes.or((VoxelShape)this.getSourceShape(state), (VoxelShape[])new VoxelShape[]{this.getTargetShape(state), this.getCoreShape(state)}).optimize();
    }

    default public VoxelShape getShape(BlockState state, BlockPos pos, HitResult result) {
        if (result != null && result.getType() == HitResult.Type.BLOCK && ((BlockHitResult)result).getBlockPos().equals((Object)pos)) {
            Vec3 hit = result.getLocation();
            VoxelShape source = this.getSourceShape(state);
            VoxelShape target = this.getTargetShape(state);
            VoxelShape core = this.getCoreShape(state);
            if (ShapeHelper.vectorCollideWithShape(source, pos, hit)) {
                return source;
            }
            if (ShapeHelper.vectorCollideWithShape(target, pos, hit)) {
                return target;
            }
            if (ShapeHelper.vectorCollideWithShape(core, pos, hit)) {
                return core;
            }
        }
        return this.getCurrentShape(state);
    }

    default public ItemInteractionResult moveIO(BlockState state, Level level, BlockPos pos, BlockHitResult hit) {
        return this.moveIO(state, level, pos, hit, this.getShape(state, pos, (HitResult)hit));
    }

    default public ItemInteractionResult moveIO(BlockState state, Level level, BlockPos pos, BlockHitResult hit, VoxelShape shape) {
        Direction direction = hit.getDirection().getOpposite();
        if (state.getValue((Property)SOURCE) == direction || state.getValue((Property)TARGET) == direction) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (ECShapes.SOURCE_SHAPES.contains(shape)) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)SOURCE, (Comparable)direction));
            return ItemInteractionResult.SUCCESS;
        }
        if (ECShapes.TARGET_SHAPES.contains(shape)) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)TARGET, (Comparable)direction));
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

