/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.vacuum;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.network.PacketDistributor;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.entity.properties.IConfigurableBlockEntityProperties;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrade;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.block.shrine.upgrade.vortex.VortexPullPlayerPayload;
import sirttas.elementalcraft.container.ECContainerHelper;
import sirttas.elementalcraft.entity.EntityHelper;
import sirttas.elementalcraft.particle.ParticleHelper;

public class VacuumShrineBlockEntity
extends AbstractShrineBlockEntity {
    public static final ResourceKey<IConfigurableBlockEntityProperties> PROPERTIES_KEY = IConfigurableBlockEntityProperties.createKey("vacuumshrine");
    private static final Holder<IConfigurableBlockEntityProperties> PROPERTIES = ElementalCraft.CONFIGURABLE_BLOCK_ENTITY_PROPERTIES_MANAGER.getOrCreateHolder(PROPERTIES_KEY);

    public VacuumShrineBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.VACUUM_SHRINE, PROPERTIES, pos, state);
    }

    private List<? extends Entity> getEntities() {
        if (this.hasUpgrade(ShrineUpgrades.VORTEX)) {
            boolean protection = this.hasUpgrade(ShrineUpgrades.PROTECTION);
            return this.getLevel().getEntitiesOfClass(LivingEntity.class, this.getRange()).stream().filter(e -> {
                if (e instanceof Player) {
                    Player player = (Player)e;
                    if (player.getAbilities().instabuild) return false;
                }
                if (!protection) return true;
                if (!EntityHelper.isHostile((Entity)e)) return false;
                return true;
            }).toList();
        }
        return this.getLevel().getEntitiesOfClass(ItemEntity.class, this.getRange());
    }

    @Override
    protected boolean doPeriod() {
        IItemHandler inv = ECContainerHelper.getItemHandlerAt((BlockGetter)this.level, this.worldPosition.below(), Direction.UP);
        return this.hasUpgrade(ShrineUpgrades.PICKUP) ? this.pickup(inv) : this.pull(inv);
    }

    private boolean pickup(IItemHandler inv) {
        return this.getEntities().stream().findAny().map(entity -> {
            this.doPickup(inv, (ItemEntity)entity);
            return true;
        }).orElse(false);
    }

    private boolean pull(IItemHandler inv) {
        int consumeAmount = this.getConsumeAmount();
        double pullSpeed = this.getStrength();
        Vec3 pos3d = Vec3.atCenterOf((Vec3i)this.getTargetPos());
        this.getEntities().forEach(entity -> {
            if (this.elementStorage.getElementAmount() >= consumeAmount) {
                this.consumeElement(consumeAmount);
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new VortexPullPlayerPayload(pos3d, pullSpeed), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else {
                    entity.setDeltaMovement(pos3d.subtract(entity.position()).normalize().multiply(pullSpeed, pullSpeed, pullSpeed));
                }
                if (entity instanceof ItemEntity) {
                    ItemEntity itemEntity = (ItemEntity)entity;
                    if (pos3d.distanceTo(entity.position()) <= (double)(2.0f * Math.max(1.0f, this.getMultiplier(ShrineUpgrade.BonusType.RANGE)))) {
                        this.doPickup(inv, itemEntity);
                    }
                }
            }
        });
        return false;
    }

    private void doPickup(IItemHandler inv, ItemEntity entity) {
        entity.setItem(ItemHandlerHelper.insertItem((IItemHandler)inv, (ItemStack)entity.getItem(), (boolean)false));
        ParticleHelper.createEnderParticle(this.level, entity.position(), 3, this.level.random);
    }
}

