/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.vacuum;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.shape.ECShapes;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlock;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.vacuum.VacuumShrineBlockEntity;
import sirttas.elementalcraft.particle.ParticleHelper;

public class VacuumShrineBlock
extends AbstractShrineBlock<VacuumShrineBlockEntity> {
    public static final String NAME = "vacuumshrine";
    public static final MapCodec<VacuumShrineBlock> CODEC = VacuumShrineBlock.simpleCodec(VacuumShrineBlock::new);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)ECShapes.SHRINE_SHAPE, (VoxelShape)Block.box((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)15.0, (double)10.0));

    public VacuumShrineBlock(BlockBehaviour.Properties properties) {
        super(ElementType.AIR, properties);
    }

    @NotNull
    protected MapCodec<VacuumShrineBlock> codec() {
        return CODEC;
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    @Override
    protected void doAnimateTick(AbstractShrineBlockEntity shrine, BlockState state, Level level, BlockPos pos, RandomSource rand) {
        ParticleHelper.createEnderParticle(level, Vec3.atLowerCornerOf((Vec3i)pos), 3, rand);
    }
}

