/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.upgrade.vortex;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.shrine.upgrade.AbstractShrineUpgradeBlock;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.block.shrine.upgrade.vortex.VortexShrineUpgradeBlockEntity;

public class VortexShrineUpgradeBlock
extends AbstractShrineUpgradeBlock
implements EntityBlock {
    public static final String NAME = "shrine_upgrade_vortex";
    public static final MapCodec<VortexShrineUpgradeBlock> CODEC = VortexShrineUpgradeBlock.simpleCodec(VortexShrineUpgradeBlock::new);
    private static final VoxelShape SHAPE = Block.box((double)6.0, (double)-1.0, (double)6.0, (double)10.0, (double)14.0, (double)10.0);

    public VortexShrineUpgradeBlock(BlockBehaviour.Properties properties) {
        super(ShrineUpgrades.VORTEX, properties);
    }

    @NotNull
    protected MapCodec<VortexShrineUpgradeBlock> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new VortexShrineUpgradeBlockEntity(pos, state);
    }

    @Override
    @Nonnull
    public Direction getFacing(@Nonnull BlockState state) {
        return Direction.DOWN;
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    @Override
    public void appendHoverText(@Nonnull ItemStack stack, @Nullable Item.TooltipContext tooltipContext, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.elementalcraft.shrine_upgrade.vortex").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, tooltipContext, tooltip, flag);
    }
}

