/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.upgrade.vortex;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.network.payload.PayloadHelper;

public record VortexPullPlayerPayload(Vec3 target, double speed) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<VortexPullPlayerPayload> TYPE = PayloadHelper.createType("vortex_pull_player");
    public static final StreamCodec<FriendlyByteBuf, VortexPullPlayerPayload> STREAM_CODEC = StreamCodec.of((b, p) -> p.write((FriendlyByteBuf)b), VortexPullPlayerPayload::new);

    public VortexPullPlayerPayload(FriendlyByteBuf buf) {
        this(new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()), buf.readDouble());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeDouble(this.target.x);
        buf.writeDouble(this.target.y);
        buf.writeDouble(this.target.z);
        buf.writeDouble(this.speed);
    }

    @NotNull
    public CustomPacketPayload.Type<VortexPullPlayerPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext payloadContext) {
        payloadContext.enqueueWork(() -> {
            Player player = payloadContext.player();
            player.setDeltaMovement(this.target.subtract(player.position()).normalize().multiply(this.speed, this.speed, this.speed));
        });
    }
}

