/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.upgrade.translocation;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.component.ECDataComponents;

public class TranslocationShrineUpgradeBlockItem
extends BlockItem {
    public TranslocationShrineUpgradeBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public static BlockPos getTargetAnchor(Player player) {
        BlockPos pos = TranslocationShrineUpgradeBlockItem.getTargetPos(player.getMainHandItem());
        if (pos == null) {
            pos = TranslocationShrineUpgradeBlockItem.getTargetPos(player.getOffhandItem());
        }
        return pos;
    }

    @Nonnull
    public InteractionResult useOn(@Nonnull UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        if (context.getLevel().getBlockState(pos).is((Block)ECBlocks.TRANSLOCATION_ANCHOR.get())) {
            this.setTargetPos(context.getItemInHand(), pos);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    private void setTargetPos(ItemStack stack, BlockPos pos) {
        stack.set(ECDataComponents.TARGET_POS, (Object)pos);
    }

    public static BlockPos getTargetPos(ItemStack stack) {
        return (BlockPos)stack.get(ECDataComponents.TARGET_POS);
    }
}

