/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.upgrade.translocation;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.entity.AbstractECBlockEntity;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.component.ECDataComponents;

public class TranslocationShrineUpgradeBlockEntity
extends AbstractECBlockEntity {
    private BlockPos target;

    public TranslocationShrineUpgradeBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.TRANSLOCATION_SHRINE_UPGRADE, pos, state);
    }

    @Nullable
    public BlockPos getTarget() {
        return this.target;
    }

    public void setTarget(@Nullable BlockPos target) {
        this.target = target;
    }

    public void loadAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        NbtUtils.readBlockPos((CompoundTag)tag, (String)"target_pos").ifPresent(this::setTarget);
    }

    protected void saveAdditional(@Nonnull CompoundTag tag, @Nonnull HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.target != null) {
            tag.put("target_pos", NbtUtils.writeBlockPos((BlockPos)this.target));
        }
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        BlockPos pos = (BlockPos)input.get(ECDataComponents.TARGET_POS);
        if (pos != null) {
            this.setTarget(pos);
        }
    }

    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        if (this.target != null) {
            builder.set(ECDataComponents.TARGET_POS, (Object)this.target);
        }
    }

    @Deprecated
    public void removeComponentsFromTag(@NotNull CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("target_pos");
    }
}

