/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.upgrade.horizontal;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.shrine.budding.BuddingShrineBlock;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.block.shrine.upgrade.horizontal.AbstractHorizontalShrineUpgradeBlock;

public class SpringalineShrineUpgradeBlock
extends AbstractHorizontalShrineUpgradeBlock {
    public static final String NAME = "shrine_upgrade_springaline";
    public static final MapCodec<SpringalineShrineUpgradeBlock> CODEC = SpringalineShrineUpgradeBlock.simpleCodec(SpringalineShrineUpgradeBlock::new);
    private static final VoxelShape BASE_NORTH = Block.box((double)5.0, (double)5.0, (double)4.0, (double)11.0, (double)11.0, (double)10.0);
    private static final VoxelShape PLATE_SOUTH_NORTH = Block.box((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)11.0);
    private static final VoxelShape PLATE_UP_NORTH = Block.box((double)6.0, (double)11.0, (double)5.0, (double)10.0, (double)12.0, (double)9.0);
    private static final VoxelShape PLATE_DOWN_NORTH = Block.box((double)6.0, (double)4.0, (double)5.0, (double)10.0, (double)5.0, (double)9.0);
    private static final VoxelShape PLATE_WEST_NORTH = Block.box((double)4.0, (double)6.0, (double)5.0, (double)5.0, (double)10.0, (double)9.0);
    private static final VoxelShape PLATE_EAST_NORTH = Block.box((double)11.0, (double)6.0, (double)5.0, (double)12.0, (double)10.0, (double)9.0);
    private static final VoxelShape PIPE_NORTH = Block.box((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)4.0);
    private static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)BASE_NORTH, (VoxelShape[])new VoxelShape[]{PIPE_NORTH, PLATE_SOUTH_NORTH, PLATE_UP_NORTH, PLATE_DOWN_NORTH, PLATE_WEST_NORTH, PLATE_EAST_NORTH});
    private static final VoxelShape BASE_SOUTH = Block.box((double)5.0, (double)5.0, (double)6.0, (double)11.0, (double)11.0, (double)12.0);
    private static final VoxelShape PLATE_NORTH_SOUTH = Block.box((double)6.0, (double)6.0, (double)5.0, (double)10.0, (double)10.0, (double)6.0);
    private static final VoxelShape PLATE_UP_SOUTH = Block.box((double)6.0, (double)11.0, (double)7.0, (double)10.0, (double)12.0, (double)11.0);
    private static final VoxelShape PLATE_DOWN_SOUTH = Block.box((double)6.0, (double)4.0, (double)7.0, (double)10.0, (double)5.0, (double)11.0);
    private static final VoxelShape PLATE_WEST_SOUTH = Block.box((double)4.0, (double)6.0, (double)7.0, (double)5.0, (double)10.0, (double)11.0);
    private static final VoxelShape PLATE_EAST_SOUTH = Block.box((double)11.0, (double)6.0, (double)7.0, (double)12.0, (double)10.0, (double)11.0);
    private static final VoxelShape PIPE_SOUTH = Block.box((double)7.0, (double)7.0, (double)12.0, (double)9.0, (double)9.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)BASE_SOUTH, (VoxelShape[])new VoxelShape[]{PIPE_SOUTH, PLATE_NORTH_SOUTH, PLATE_UP_SOUTH, PLATE_DOWN_SOUTH, PLATE_WEST_SOUTH, PLATE_EAST_SOUTH});
    private static final VoxelShape BASE_WEST = Block.box((double)4.0, (double)5.0, (double)5.0, (double)10.0, (double)11.0, (double)11.0);
    private static final VoxelShape PLATE_EAST_WEST = Block.box((double)10.0, (double)6.0, (double)6.0, (double)11.0, (double)10.0, (double)10.0);
    private static final VoxelShape PLATE_UP_WEST = Block.box((double)5.0, (double)11.0, (double)6.0, (double)9.0, (double)12.0, (double)10.0);
    private static final VoxelShape PLATE_DOWN_WEST = Block.box((double)5.0, (double)4.0, (double)6.0, (double)9.0, (double)5.0, (double)10.0);
    private static final VoxelShape PLATE_NORTH_WEST = Block.box((double)5.0, (double)6.0, (double)4.0, (double)9.0, (double)10.0, (double)5.0);
    private static final VoxelShape PLATE_SOUTH_WEST = Block.box((double)5.0, (double)6.0, (double)11.0, (double)9.0, (double)10.0, (double)12.0);
    private static final VoxelShape PIPE_WEST = Block.box((double)0.0, (double)7.0, (double)7.0, (double)4.0, (double)9.0, (double)9.0);
    private static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)BASE_WEST, (VoxelShape[])new VoxelShape[]{PIPE_WEST, PLATE_EAST_WEST, PLATE_UP_WEST, PLATE_DOWN_WEST, PLATE_NORTH_WEST, PLATE_SOUTH_WEST});
    private static final VoxelShape BASE_EAST = Block.box((double)6.0, (double)5.0, (double)5.0, (double)12.0, (double)11.0, (double)11.0);
    private static final VoxelShape PLATE_WEST_EAST = Block.box((double)5.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0);
    private static final VoxelShape PLATE_UP_EAST = Block.box((double)7.0, (double)11.0, (double)6.0, (double)11.0, (double)12.0, (double)10.0);
    private static final VoxelShape PLATE_DOWN_EAST = Block.box((double)7.0, (double)4.0, (double)6.0, (double)11.0, (double)5.0, (double)10.0);
    private static final VoxelShape PLATE_NORTH_EAST = Block.box((double)7.0, (double)6.0, (double)4.0, (double)11.0, (double)10.0, (double)5.0);
    private static final VoxelShape PLATE_SOUTH_EAST = Block.box((double)7.0, (double)6.0, (double)11.0, (double)11.0, (double)10.0, (double)12.0);
    private static final VoxelShape PIPE_EAST = Block.box((double)12.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    private static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)BASE_EAST, (VoxelShape[])new VoxelShape[]{PIPE_EAST, PLATE_WEST_EAST, PLATE_UP_EAST, PLATE_DOWN_EAST, PLATE_NORTH_EAST, PLATE_SOUTH_EAST});

    public SpringalineShrineUpgradeBlock(BlockBehaviour.Properties properties) {
        super(ShrineUpgrades.SPRINGALINE, properties);
    }

    @NotNull
    protected MapCodec<SpringalineShrineUpgradeBlock> codec() {
        return CODEC;
    }

    public static VoxelShape getShape(BlockState state) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.EAST -> SHAPE_EAST;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SpringalineShrineUpgradeBlock.getShape(state);
    }

    @Override
    public void setPlacedBy(@Nonnull Level level, BlockPos pos, @Nonnull BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        this.setShrineState(level, pos.relative(this.getFacing(state)), BuddingShrineBlock.CrystalType.SPRINGALINE);
    }

    @Override
    public void onRemove(@Nonnull BlockState state, @Nonnull Level level, BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        super.onRemove(state, level, pos, newState, isMoving);
        this.setShrineState(level, pos.relative(this.getFacing(state)), BuddingShrineBlock.CrystalType.AMETHYST);
    }

    private void setShrineState(Level level, BlockPos pos, BuddingShrineBlock.CrystalType type) {
        BlockState shrineState = level.getBlockState(pos);
        if (shrineState.is((Block)ECBlocks.BUDDING_SHRINE.get())) {
            level.setBlockAndUpdate(pos, (BlockState)shrineState.setValue(BuddingShrineBlock.CRYSTAL_TYPE, (Comparable)((Object)type)));
        }
    }

    @Override
    public void appendHoverText(@Nonnull ItemStack stack, @Nullable Item.TooltipContext tooltipContext, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.elementalcraft.shrine_upgrade.springaline").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, tooltipContext, tooltip, flag);
    }
}

