/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.upgrade.horizontal;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.block.shrine.upgrade.horizontal.AbstractHorizontalShrineUpgradeBlock;
import sirttas.elementalcraft.tag.ECTags;

public class SilkTouchShrineUpgradeBlock
extends AbstractHorizontalShrineUpgradeBlock {
    public static final String NAME = "shrine_upgrade_silk_touch";
    public static final MapCodec<SilkTouchShrineUpgradeBlock> CODEC = SilkTouchShrineUpgradeBlock.simpleCodec(SilkTouchShrineUpgradeBlock::new);
    private static final VoxelShape CORE_NORTH = Block.box((double)6.0, (double)6.0, (double)4.0, (double)10.0, (double)16.0, (double)8.0);
    private static final VoxelShape PILAR_NORTH = Block.box((double)7.0, (double)2.0, (double)5.0, (double)9.0, (double)6.0, (double)7.0);
    private static final VoxelShape BASE_1_NORTH = Block.box((double)5.0, (double)0.0, (double)3.0, (double)11.0, (double)1.0, (double)9.0);
    private static final VoxelShape BASE_2_NORTH = Block.box((double)6.0, (double)1.0, (double)4.0, (double)10.0, (double)2.0, (double)8.0);
    private static final VoxelShape PIPE_NORTH = Block.box((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)4.0);
    private static final VoxelShape ATTACH_NORTH = Block.box((double)7.0, (double)13.0, (double)-2.0, (double)9.0, (double)15.0, (double)4.0);
    private static final VoxelShape CORE_SOUTH = Block.box((double)6.0, (double)6.0, (double)8.0, (double)10.0, (double)16.0, (double)12.0);
    private static final VoxelShape PILAR_SOUTH = Block.box((double)7.0, (double)2.0, (double)9.0, (double)9.0, (double)6.0, (double)11.0);
    private static final VoxelShape BASE_1_SOUTH = Block.box((double)5.0, (double)0.0, (double)7.0, (double)11.0, (double)1.0, (double)13.0);
    private static final VoxelShape BASE_2_SOUTH = Block.box((double)6.0, (double)1.0, (double)8.0, (double)10.0, (double)2.0, (double)12.0);
    private static final VoxelShape PIPE_SOUTH = Block.box((double)7.0, (double)7.0, (double)12.0, (double)9.0, (double)9.0, (double)16.0);
    private static final VoxelShape ATTACH_SOUTH = Block.box((double)7.0, (double)13.0, (double)12.0, (double)9.0, (double)15.0, (double)18.0);
    private static final VoxelShape CORE_WEST = Block.box((double)4.0, (double)6.0, (double)6.0, (double)8.0, (double)16.0, (double)10.0);
    private static final VoxelShape PILAR_WEST = Block.box((double)5.0, (double)2.0, (double)7.0, (double)7.0, (double)6.0, (double)9.0);
    private static final VoxelShape BASE_1_WEST = Block.box((double)3.0, (double)0.0, (double)5.0, (double)9.0, (double)1.0, (double)11.0);
    private static final VoxelShape BASE_2_WEST = Block.box((double)4.0, (double)1.0, (double)6.0, (double)8.0, (double)2.0, (double)10.0);
    private static final VoxelShape PIPE_WEST = Block.box((double)0.0, (double)7.0, (double)7.0, (double)4.0, (double)9.0, (double)9.0);
    private static final VoxelShape ATTACH_WEST = Block.box((double)-2.0, (double)13.0, (double)7.0, (double)4.0, (double)15.0, (double)9.0);
    private static final VoxelShape CORE_EAST = Block.box((double)8.0, (double)6.0, (double)6.0, (double)12.0, (double)16.0, (double)10.0);
    private static final VoxelShape PILAR_EAST = Block.box((double)9.0, (double)2.0, (double)7.0, (double)11.0, (double)6.0, (double)9.0);
    private static final VoxelShape BASE_1_EAST = Block.box((double)7.0, (double)0.0, (double)5.0, (double)13.0, (double)1.0, (double)11.0);
    private static final VoxelShape BASE_2_EAST = Block.box((double)8.0, (double)1.0, (double)6.0, (double)12.0, (double)2.0, (double)10.0);
    private static final VoxelShape PIPE_EAST = Block.box((double)12.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    private static final VoxelShape ATTACH_EAST = Block.box((double)12.0, (double)13.0, (double)7.0, (double)18.0, (double)15.0, (double)9.0);
    private static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)CORE_NORTH, (VoxelShape[])new VoxelShape[]{PILAR_NORTH, BASE_1_NORTH, BASE_2_NORTH, PIPE_NORTH});
    private static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)CORE_SOUTH, (VoxelShape[])new VoxelShape[]{PILAR_SOUTH, BASE_1_SOUTH, BASE_2_SOUTH, PIPE_SOUTH});
    private static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)CORE_WEST, (VoxelShape[])new VoxelShape[]{PILAR_WEST, BASE_1_WEST, BASE_2_WEST, PIPE_WEST});
    private static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)CORE_EAST, (VoxelShape[])new VoxelShape[]{PILAR_EAST, BASE_1_EAST, BASE_2_EAST, PIPE_EAST});
    private static final VoxelShape SHAPE_NORTH_ATTACHED = Shapes.or((VoxelShape)SHAPE_NORTH, (VoxelShape)ATTACH_NORTH);
    private static final VoxelShape SHAPE_SOUTH_ATTACHED = Shapes.or((VoxelShape)SHAPE_SOUTH, (VoxelShape)ATTACH_SOUTH);
    private static final VoxelShape SHAPE_WEST_ATTACHED = Shapes.or((VoxelShape)SHAPE_WEST, (VoxelShape)ATTACH_WEST);
    private static final VoxelShape SHAPE_EAST_ATTACHED = Shapes.or((VoxelShape)SHAPE_EAST, (VoxelShape)ATTACH_EAST);

    public SilkTouchShrineUpgradeBlock(BlockBehaviour.Properties properties) {
        super(ShrineUpgrades.SILK_TOUCH, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<SilkTouchShrineUpgradeBlock> codec() {
        return CODEC;
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        if (Boolean.TRUE.equals(state.getValue((Property)BlockStateProperties.ATTACHED))) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                case Direction.SOUTH -> SHAPE_SOUTH_ATTACHED;
                case Direction.WEST -> SHAPE_WEST_ATTACHED;
                case Direction.EAST -> SHAPE_EAST_ATTACHED;
                default -> SHAPE_NORTH_ATTACHED;
            };
        }
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_NORTH;
        };
    }

    @Override
    public void appendHoverText(@Nonnull ItemStack stack, @Nullable Item.TooltipContext tooltipContext, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"enchantment.minecraft.shrine_upgrade.silk_touch").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, tooltipContext, tooltip, flag);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        return (BlockState)state.setValue((Property)BlockStateProperties.ATTACHED, (Comparable)Boolean.valueOf(context.getLevel().getBlockState(context.getClickedPos().relative(facing)).is(ECTags.Blocks.SHRINES_UPGRADABLES_SILK_TOUCH_ATTACHED)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> container) {
        super.createBlockStateDefinition(container);
        container.add(new Property[]{BlockStateProperties.ATTACHED});
    }
}

