/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.upgrade.horizontal;

import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.block.shrine.upgrade.horizontal.AbstractHorizontalShrineUpgradeBlock;

public class CrystalHarvestShrineUpgradeBlock
extends AbstractHorizontalShrineUpgradeBlock {
    public static final String NAME = "shrine_upgrade_crystal_harvest";
    public static final MapCodec<CrystalHarvestShrineUpgradeBlock> CODEC = CrystalHarvestShrineUpgradeBlock.simpleCodec(CrystalHarvestShrineUpgradeBlock::new);
    private static final VoxelShape CORE_1_NORTH = Block.box((double)5.0, (double)5.0, (double)4.0, (double)11.0, (double)16.0, (double)7.0);
    private static final VoxelShape CORE_2_NORTH = Block.box((double)6.0, (double)6.0, (double)7.0, (double)10.0, (double)10.0, (double)9.0);
    private static final VoxelShape PIPE_1_NORTH = Block.box((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)4.0);
    private static final VoxelShape PIPE_2_NORTH = Block.box((double)7.0, (double)13.0, (double)-2.0, (double)9.0, (double)15.0, (double)4.0);
    private static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)CORE_1_NORTH, (VoxelShape[])new VoxelShape[]{CORE_2_NORTH, PIPE_1_NORTH, PIPE_2_NORTH});
    private static final VoxelShape CORE_1_SOUTH = Block.box((double)5.0, (double)5.0, (double)9.0, (double)11.0, (double)16.0, (double)12.0);
    private static final VoxelShape CORE_2_SOUTH = Block.box((double)6.0, (double)6.0, (double)7.0, (double)10.0, (double)10.0, (double)9.0);
    private static final VoxelShape PIPE_1_SOUTH = Block.box((double)7.0, (double)7.0, (double)12.0, (double)9.0, (double)9.0, (double)16.0);
    private static final VoxelShape PIPE_2_SOUTH = Block.box((double)7.0, (double)13.0, (double)12.0, (double)9.0, (double)15.0, (double)18.0);
    private static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)CORE_1_SOUTH, (VoxelShape[])new VoxelShape[]{CORE_2_SOUTH, PIPE_1_SOUTH, PIPE_2_SOUTH});
    private static final VoxelShape CORE_1_WEST = Block.box((double)4.0, (double)5.0, (double)5.0, (double)7.0, (double)16.0, (double)11.0);
    private static final VoxelShape CORE_2_WEST = Block.box((double)7.0, (double)6.0, (double)6.0, (double)9.0, (double)10.0, (double)10.0);
    private static final VoxelShape PIPE_1_WEST = Block.box((double)0.0, (double)7.0, (double)7.0, (double)4.0, (double)9.0, (double)9.0);
    private static final VoxelShape PIPE_2_WEST = Block.box((double)-2.0, (double)13.0, (double)7.0, (double)4.0, (double)15.0, (double)9.0);
    private static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)CORE_1_WEST, (VoxelShape[])new VoxelShape[]{CORE_2_WEST, PIPE_1_WEST, PIPE_2_WEST});
    private static final VoxelShape CORE_1_EAST = Block.box((double)9.0, (double)5.0, (double)5.0, (double)12.0, (double)16.0, (double)11.0);
    private static final VoxelShape CORE_2_EAST = Block.box((double)7.0, (double)6.0, (double)6.0, (double)9.0, (double)10.0, (double)10.0);
    private static final VoxelShape PIPE_1_EAST = Block.box((double)12.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    private static final VoxelShape PIPE_2_EAST = Block.box((double)12.0, (double)13.0, (double)7.0, (double)18.0, (double)15.0, (double)9.0);
    private static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)CORE_1_EAST, (VoxelShape[])new VoxelShape[]{CORE_2_EAST, PIPE_1_EAST, PIPE_2_EAST});

    public CrystalHarvestShrineUpgradeBlock(BlockBehaviour.Properties properties) {
        super(ShrineUpgrades.CRYSTAL_HARVEST, properties);
    }

    @NotNull
    protected MapCodec<CrystalHarvestShrineUpgradeBlock> codec() {
        return CODEC;
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_NORTH;
        };
    }

    @Override
    public void appendHoverText(@Nonnull ItemStack stack, @Nullable Item.TooltipContext tooltipContext, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.elementalcraft.shrine_upgrade.crystal_harvest").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, tooltipContext, tooltip, flag);
    }
}

