/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.upgrade.fortune;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.block.shrine.upgrade.fortune.AbstractFortuneShrineUpgradeBlock;
import sirttas.elementalcraft.config.ECConfig;

public class FortuneShrineUpgradeBlock
extends AbstractFortuneShrineUpgradeBlock {
    public static final String NAME = "shrine_upgrade_fortune";
    public static final MapCodec<FortuneShrineUpgradeBlock> CODEC = FortuneShrineUpgradeBlock.simpleCodec(FortuneShrineUpgradeBlock::new);
    private static final VoxelShape CORE_NORTH = FortuneShrineUpgradeBlock.box((double)6.0, (double)6.0, (double)4.0, (double)10.0, (double)10.0, (double)8.0);
    private static final VoxelShape PILAR_NORTH = FortuneShrineUpgradeBlock.box((double)7.0, (double)2.0, (double)5.0, (double)9.0, (double)6.0, (double)7.0);
    private static final VoxelShape BASE_1_NORTH = FortuneShrineUpgradeBlock.box((double)5.0, (double)0.0, (double)3.0, (double)11.0, (double)1.0, (double)9.0);
    private static final VoxelShape BASE_2_NORTH = FortuneShrineUpgradeBlock.box((double)6.0, (double)1.0, (double)4.0, (double)10.0, (double)2.0, (double)8.0);
    private static final VoxelShape PIPE_NORTH = FortuneShrineUpgradeBlock.box((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)4.0);
    private static final VoxelShape CORE_SOUTH = FortuneShrineUpgradeBlock.box((double)6.0, (double)6.0, (double)8.0, (double)10.0, (double)10.0, (double)12.0);
    private static final VoxelShape PILAR_SOUTH = FortuneShrineUpgradeBlock.box((double)7.0, (double)2.0, (double)9.0, (double)9.0, (double)6.0, (double)11.0);
    private static final VoxelShape BASE_1_SOUTH = FortuneShrineUpgradeBlock.box((double)5.0, (double)0.0, (double)7.0, (double)11.0, (double)1.0, (double)13.0);
    private static final VoxelShape BASE_2_SOUTH = FortuneShrineUpgradeBlock.box((double)6.0, (double)1.0, (double)8.0, (double)10.0, (double)2.0, (double)12.0);
    private static final VoxelShape PIPE_SOUTH = FortuneShrineUpgradeBlock.box((double)7.0, (double)7.0, (double)12.0, (double)9.0, (double)9.0, (double)16.0);
    private static final VoxelShape CORE_WEST = FortuneShrineUpgradeBlock.box((double)4.0, (double)6.0, (double)6.0, (double)8.0, (double)10.0, (double)10.0);
    private static final VoxelShape PILAR_WEST = FortuneShrineUpgradeBlock.box((double)5.0, (double)2.0, (double)7.0, (double)7.0, (double)6.0, (double)9.0);
    private static final VoxelShape BASE_1_WEST = FortuneShrineUpgradeBlock.box((double)3.0, (double)0.0, (double)5.0, (double)9.0, (double)1.0, (double)11.0);
    private static final VoxelShape BASE_2_WEST = FortuneShrineUpgradeBlock.box((double)4.0, (double)1.0, (double)6.0, (double)8.0, (double)2.0, (double)10.0);
    private static final VoxelShape PIPE_WEST = FortuneShrineUpgradeBlock.box((double)0.0, (double)7.0, (double)7.0, (double)4.0, (double)9.0, (double)9.0);
    private static final VoxelShape CORE_EAST = FortuneShrineUpgradeBlock.box((double)8.0, (double)6.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0);
    private static final VoxelShape PILAR_EAST = FortuneShrineUpgradeBlock.box((double)9.0, (double)2.0, (double)7.0, (double)11.0, (double)6.0, (double)9.0);
    private static final VoxelShape BASE_1_EAST = FortuneShrineUpgradeBlock.box((double)7.0, (double)0.0, (double)5.0, (double)13.0, (double)1.0, (double)11.0);
    private static final VoxelShape BASE_2_EAST = FortuneShrineUpgradeBlock.box((double)8.0, (double)1.0, (double)6.0, (double)12.0, (double)2.0, (double)10.0);
    private static final VoxelShape PIPE_EAST = FortuneShrineUpgradeBlock.box((double)12.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    private static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)CORE_NORTH, (VoxelShape[])new VoxelShape[]{PILAR_NORTH, BASE_1_NORTH, BASE_2_NORTH, PIPE_NORTH});
    private static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)CORE_SOUTH, (VoxelShape[])new VoxelShape[]{PILAR_SOUTH, BASE_1_SOUTH, BASE_2_SOUTH, PIPE_SOUTH});
    private static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)CORE_WEST, (VoxelShape[])new VoxelShape[]{PILAR_WEST, BASE_1_WEST, BASE_2_WEST, PIPE_WEST});
    private static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)CORE_EAST, (VoxelShape[])new VoxelShape[]{PILAR_EAST, BASE_1_EAST, BASE_2_EAST, PIPE_EAST});

    public FortuneShrineUpgradeBlock(BlockBehaviour.Properties properties) {
        super(ShrineUpgrades.FORTUNE, properties);
    }

    @NotNull
    protected MapCodec<FortuneShrineUpgradeBlock> codec() {
        return CODEC;
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_NORTH;
        };
    }

    @Override
    public int getFortuneLevel() {
        return (Integer)ECConfig.SERVER.fortuneShrineUpgradeLevel.get();
    }
}

