/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.upgrade.directional;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.shape.ShapeHelper;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.block.shrine.upgrade.directional.AbstractDirectionalShrineUpgradeBlock;

public class FillingShrineUpgradeBlock
extends AbstractDirectionalShrineUpgradeBlock {
    public static final String NAME = "shrine_upgrade_filling";
    public static final MapCodec<FillingShrineUpgradeBlock> CODEC = FillingShrineUpgradeBlock.simpleCodec(FillingShrineUpgradeBlock::new);
    private static final VoxelShape BASE = Block.box((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape PIPE_UP = Block.box((double)7.0, (double)8.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape PIPE_NORTH = Block.box((double)7.0, (double)0.0, (double)4.0, (double)9.0, (double)4.0, (double)6.0);
    private static final VoxelShape PIPE_SOUTH = Block.box((double)7.0, (double)0.0, (double)10.0, (double)9.0, (double)4.0, (double)12.0);
    private static final VoxelShape PIPE_WEST = Block.box((double)4.0, (double)0.0, (double)7.0, (double)6.0, (double)4.0, (double)9.0);
    private static final VoxelShape PIPE_EAST = Block.box((double)10.0, (double)0.0, (double)7.0, (double)12.0, (double)4.0, (double)9.0);
    private static final VoxelShape PIPE_NORTH_WEST = Block.box((double)4.0, (double)0.0, (double)4.0, (double)6.0, (double)4.0, (double)6.0);
    private static final VoxelShape PIPE_NORTH_EAST = Block.box((double)10.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)6.0);
    private static final VoxelShape PIPE_SOUTH_WEST = Block.box((double)4.0, (double)0.0, (double)10.0, (double)6.0, (double)4.0, (double)12.0);
    private static final VoxelShape PIPE_SOUTH_EAST = Block.box((double)10.0, (double)0.0, (double)10.0, (double)12.0, (double)4.0, (double)12.0);
    private static final VoxelShape DOWN_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{PIPE_UP, PIPE_NORTH, PIPE_SOUTH, PIPE_WEST, PIPE_EAST, PIPE_NORTH_WEST, PIPE_NORTH_EAST, PIPE_SOUTH_WEST, PIPE_SOUTH_EAST});
    private static final Map<Direction, VoxelShape> VERTICAL_SHAPES = ShapeHelper.directionShapes(DOWN_SHAPE);
    private static final VoxelShape NORTH_SHAPE = Shapes.or((VoxelShape)VERTICAL_SHAPES.get(Direction.SOUTH), (VoxelShape[])new VoxelShape[]{Block.box((double)4.0, (double)10.0, (double)-3.0, (double)6.0, (double)12.0, (double)0.0), Block.box((double)7.0, (double)10.0, (double)-3.0, (double)9.0, (double)12.0, (double)0.0), Block.box((double)10.0, (double)10.0, (double)-3.0, (double)12.0, (double)12.0, (double)0.0), Block.box((double)4.0, (double)7.0, (double)-3.0, (double)6.0, (double)9.0, (double)0.0), Block.box((double)10.0, (double)7.0, (double)-3.0, (double)12.0, (double)9.0, (double)0.0), Block.box((double)4.0, (double)4.0, (double)-1.0, (double)6.0, (double)6.0, (double)0.0), Block.box((double)7.0, (double)4.0, (double)-1.0, (double)9.0, (double)6.0, (double)0.0), Block.box((double)10.0, (double)4.0, (double)-1.0, (double)12.0, (double)6.0, (double)0.0)});
    private static final Map<Direction, VoxelShape> HORIZONTAL_SHAPES = ShapeHelper.directionShapes(Direction.NORTH, NORTH_SHAPE);
    private static final Map<Direction, VoxelShape> SHAPES = Map.of(Direction.DOWN, DOWN_SHAPE, Direction.UP, VERTICAL_SHAPES.get(Direction.DOWN), Direction.NORTH, HORIZONTAL_SHAPES.get(Direction.NORTH), Direction.SOUTH, HORIZONTAL_SHAPES.get(Direction.SOUTH), Direction.WEST, HORIZONTAL_SHAPES.get(Direction.WEST), Direction.EAST, HORIZONTAL_SHAPES.get(Direction.EAST));

    public FillingShrineUpgradeBlock(BlockBehaviour.Properties properties) {
        super(ShrineUpgrades.FILLING, properties);
    }

    @NotNull
    protected MapCodec<FillingShrineUpgradeBlock> codec() {
        return CODEC;
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPES.get(state.getValue((Property)FACING));
    }

    @Override
    public void appendHoverText(@Nonnull ItemStack stack, @Nullable Item.TooltipContext tooltipContext, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.elementalcraft.shrine_upgrade.filling").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, tooltipContext, tooltip, flag);
    }
}

