/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.upgrade.directional;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.block.shrine.upgrade.directional.AbstractDirectionalShrineUpgradeBlock;

public class CapacityShrineUpgradeBlock
extends AbstractDirectionalShrineUpgradeBlock {
    public static final String NAME = "shrine_upgrade_capacity";
    public static final MapCodec<CapacityShrineUpgradeBlock> CODEC = CapacityShrineUpgradeBlock.simpleCodec(CapacityShrineUpgradeBlock::new);
    private static final VoxelShape BASE_UP = Block.box((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0);
    private static final VoxelShape PIPE_UP = Block.box((double)7.0, (double)12.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SHAPE_UP = Shapes.or((VoxelShape)BASE_UP, (VoxelShape)PIPE_UP);
    private static final VoxelShape BASE_DOWN = Block.box((double)5.0, (double)4.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);
    private static final VoxelShape PIPE_DOWN = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)4.0, (double)9.0);
    private static final VoxelShape SHAPE_DOWN = Shapes.or((VoxelShape)BASE_DOWN, (VoxelShape)PIPE_DOWN);
    private static final VoxelShape BASE_NORTH = Block.box((double)5.0, (double)5.0, (double)4.0, (double)11.0, (double)11.0, (double)10.0);
    private static final VoxelShape PIPE_NORTH = Block.box((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)4.0);
    private static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)BASE_NORTH, (VoxelShape)PIPE_NORTH);
    private static final VoxelShape BASE_SOUTH = Block.box((double)5.0, (double)5.0, (double)6.0, (double)11.0, (double)11.0, (double)12.0);
    private static final VoxelShape PIPE_SOUTH = Block.box((double)7.0, (double)7.0, (double)12.0, (double)9.0, (double)9.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)BASE_SOUTH, (VoxelShape)PIPE_SOUTH);
    private static final VoxelShape BASE_WEST = Block.box((double)4.0, (double)5.0, (double)5.0, (double)10.0, (double)11.0, (double)11.0);
    private static final VoxelShape PIPE_WEST = Block.box((double)0.0, (double)7.0, (double)7.0, (double)4.0, (double)9.0, (double)9.0);
    private static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)BASE_WEST, (VoxelShape)PIPE_WEST);
    private static final VoxelShape BASE_EAST = Block.box((double)6.0, (double)5.0, (double)5.0, (double)12.0, (double)11.0, (double)11.0);
    private static final VoxelShape PIPE_EAST = Block.box((double)12.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    private static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)BASE_EAST, (VoxelShape)PIPE_EAST);

    public CapacityShrineUpgradeBlock(BlockBehaviour.Properties properties) {
        super(ShrineUpgrades.CAPACITY, properties);
    }

    @NotNull
    protected MapCodec<CapacityShrineUpgradeBlock> codec() {
        return CODEC;
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.DOWN -> SHAPE_DOWN;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_UP;
        };
    }
}

