/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.upgrade.acceleration.overclocked;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.transfer.IElementTransferer;
import sirttas.elementalcraft.api.element.transfer.path.IElementTransferPathNode;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.upgrade.horizontal.AbstractHorizontalShrineUpgradeBlock;

public class OverclockedAccelerationShrineUpgradeElementTransferer
implements IElementTransferer {
    private final BlockEntity upgrade;
    private AbstractShrineBlockEntity shrine;
    private ElementPipeBlockEntity pipe;

    public OverclockedAccelerationShrineUpgradeElementTransferer(BlockEntity upgrade) {
        this.upgrade = upgrade;
    }

    @Override
    public synchronized List<IElementTransferPathNode> getConnectedNodes(@Nonnull ElementType type) {
        this.refreshShrine();
        this.refreshPipe();
        if (this.shrine != null && this.pipe != null) {
            return List.of(new ShrineNode(this.shrine), new PipeNode(this.pipe));
        }
        if (this.shrine != null) {
            return List.of(new ShrineNode(this.shrine));
        }
        if (this.pipe != null) {
            return List.of(new PipeNode(this.pipe));
        }
        return Collections.emptyList();
    }

    @Override
    public boolean canConnectTo(@Nonnull BlockPos to) {
        return to.equals((Object)this.upgrade.getBlockPos().relative(this.getFacing().getOpposite()));
    }

    private synchronized void refreshShrine() {
        this.shrine = this.getBlockEntity(this.shrine, this.getFacing(), AbstractShrineBlockEntity.class);
    }

    private synchronized void refreshPipe() {
        this.pipe = this.getBlockEntity(this.pipe, this.getFacing().getOpposite(), ElementPipeBlockEntity.class);
    }

    private <T extends BlockEntity> T getBlockEntity(T existingEntity, Direction direction, Class<T> clazz) {
        if (existingEntity != null && !existingEntity.isRemoved()) {
            return existingEntity;
        }
        Level level = this.upgrade.getLevel();
        if (level == null) {
            return null;
        }
        return (T)((BlockEntity)BlockEntityHelper.getBlockEntityAs((BlockGetter)level, this.upgrade.getBlockPos().relative(direction), clazz).orElse(null));
    }

    @Nonnull
    private Direction getFacing() {
        return (Direction)this.upgrade.getBlockState().getValue((Property)AbstractHorizontalShrineUpgradeBlock.FACING);
    }

    public void setShrine(AbstractShrineBlockEntity shrine) {
        this.shrine = shrine;
    }

    private record ShrineNode(AbstractShrineBlockEntity shrine) implements IElementTransferPathNode
    {
        @Override
        public BlockPos getPos() {
            return this.shrine.getBlockPos();
        }

        @Override
        public IElementStorage getStorage() {
            return this.shrine.getElementStorage();
        }
    }

    private record PipeNode(ElementPipeBlockEntity pipe) implements IElementTransferPathNode
    {
        @Override
        public BlockPos getPos() {
            return this.pipe.getBlockPos();
        }

        @Override
        public IElementTransferer getTransferer() {
            return this.pipe.getTransferer();
        }
    }
}

