/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.upgrade.acceleration.overclocked;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.block.pipe.IPipeConnectedBlock;
import sirttas.elementalcraft.block.shape.ShapeHelper;
import sirttas.elementalcraft.block.shrine.AbstractPylonShrineBlock;
import sirttas.elementalcraft.block.shrine.upgrade.ShrineUpgrades;
import sirttas.elementalcraft.block.shrine.upgrade.acceleration.overclocked.OverclockedAccelerationShrineUpgradeBlockEntity;
import sirttas.elementalcraft.block.shrine.upgrade.horizontal.AbstractHorizontalShrineUpgradeBlock;

public class OverclockedAccelerationShrineUpgradeBlock
extends AbstractHorizontalShrineUpgradeBlock
implements EntityBlock {
    public static final String NAME = "shrine_upgrade_overclocked_acceleration";
    public static final MapCodec<OverclockedAccelerationShrineUpgradeBlock> CODEC = OverclockedAccelerationShrineUpgradeBlock.simpleCodec(OverclockedAccelerationShrineUpgradeBlock::new);
    private static final VoxelShape CORE_1 = Block.box((double)5.0, (double)5.0, (double)3.0, (double)11.0, (double)11.0, (double)9.0);
    private static final VoxelShape CORE_2 = Block.box((double)6.0, (double)11.0, (double)4.0, (double)10.0, (double)16.0, (double)8.0);
    private static final VoxelShape PILAR = Block.box((double)7.0, (double)2.0, (double)5.0, (double)9.0, (double)5.0, (double)7.0);
    private static final VoxelShape BASE_1 = Block.box((double)5.0, (double)0.0, (double)3.0, (double)11.0, (double)1.0, (double)9.0);
    private static final VoxelShape BASE_2 = Block.box((double)6.0, (double)1.0, (double)4.0, (double)10.0, (double)2.0, (double)8.0);
    private static final VoxelShape PIPE = Block.box((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)3.0);
    private static final VoxelShape LOWER_SHAPE = Shapes.or((VoxelShape)CORE_1, (VoxelShape[])new VoxelShape[]{CORE_2, PILAR, BASE_1, BASE_2, PIPE});
    private static final VoxelShape CONNECTOR = Block.box((double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0, (double)16.0);
    private static final VoxelShape PIPE_UPPER = Block.box((double)7.0, (double)0.0, (double)5.0, (double)9.0, (double)3.0, (double)7.0);
    private static final VoxelShape CORE_UPPER = Block.box((double)5.0, (double)3.0, (double)3.0, (double)11.0, (double)9.0, (double)9.0);
    private static final Map<Direction, VoxelShape> UPPER_SHAPES = ShapeHelper.directionShapes(Direction.NORTH, Shapes.or((VoxelShape)PIPE_UPPER, (VoxelShape)CORE_UPPER));
    private static final Map<Direction, VoxelShape> LOWER_SHAPES = ShapeHelper.directionShapes(Direction.NORTH, LOWER_SHAPE);
    private static final Map<Direction, VoxelShape> CONNECTED_LOWER_SHAPES = ShapeHelper.directionShapes(Direction.NORTH, Shapes.or((VoxelShape)LOWER_SHAPE, (VoxelShape)CONNECTOR));
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final BooleanProperty CONNECTED = BooleanProperty.create((String)"connected");

    public OverclockedAccelerationShrineUpgradeBlock(BlockBehaviour.Properties properties) {
        super(ShrineUpgrades.OVERCLOCKED_ACCELERATION, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)CONNECTED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<OverclockedAccelerationShrineUpgradeBlock> codec() {
        return CODEC;
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            return UPPER_SHAPES.get(state.getValue((Property)FACING));
        }
        if (Boolean.TRUE.equals(state.getValue((Property)CONNECTED))) {
            return CONNECTED_LOWER_SHAPES.get(state.getValue((Property)FACING));
        }
        return LOWER_SHAPES.get(state.getValue((Property)FACING));
    }

    @Override
    public void setPlacedBy(@Nonnull Level level, BlockPos pos, @Nonnull BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        level.setBlock(pos.above(), (BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))), 3);
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    @Override
    @Nonnull
    public Direction getFacing(@Nonnull BlockState state) {
        return state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER ? (Direction)state.getValue((Property)FACING) : Direction.DOWN;
    }

    @Nullable
    public BlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER ? new OverclockedAccelerationShrineUpgradeBlockEntity(pos, state) : null;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> container) {
        super.createBlockStateDefinition(container);
        container.add(new Property[]{HALF, CONNECTED});
    }

    @Override
    public boolean canSurvive(@Nonnull BlockState state, @Nonnull LevelReader level, @Nonnull BlockPos pos) {
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return super.canSurvive(state, level, pos);
        }
        return level.getBlockState(pos.below()).is((Block)this);
    }

    @NotNull
    public BlockState playerWillDestroy(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        AbstractPylonShrineBlock.doubleHalfHarvest(level, pos, state, player);
        return super.playerWillDestroy(level, pos, state, player);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        if (!AbstractPylonShrineBlock.canReplaceAboveBlock(context)) {
            return null;
        }
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        return OverclockedAccelerationShrineUpgradeBlock.getConnectionState(state, (LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    @Override
    @Nonnull
    public BlockState updateShape(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        return AbstractPylonShrineBlock.doubleHalfUpdateShape(state, facing, facingState, level, pos, () -> {
            BlockState newState = super.updateShape(state, facing, facingState, level, pos, facingPos);
            return newState.is((Block)this) ? OverclockedAccelerationShrineUpgradeBlock.getConnectionState(newState, level, pos) : newState;
        });
    }

    @Nonnull
    private static BlockState getConnectionState(@Nonnull BlockState state, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos) {
        if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
            return (BlockState)state.setValue((Property)CONNECTED, (Comparable)Boolean.valueOf(false));
        }
        return (BlockState)state.setValue((Property)CONNECTED, (Comparable)Boolean.valueOf(IPipeConnectedBlock.isConnectable((BlockGetter)level, currentPos, ((Direction)state.getValue((Property)FACING)).getOpposite())));
    }
}

