/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.upgrade.acceleration;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import sirttas.elementalcraft.block.shrine.upgrade.acceleration.AccelerationShrineUpgradeBlockEntity;
import sirttas.elementalcraft.block.shrine.upgrade.directional.AbstractDirectionalShrineUpgradeBlock;
import sirttas.elementalcraft.client.model.ECModelHelper;
import sirttas.elementalcraft.renderer.ECRendererHelper;

public class AccelerationShrineUpgradeRenderer
implements BlockEntityRenderer<AccelerationShrineUpgradeBlockEntity> {
    private static final Vector3f POSITION = new Vector3f(0.0f, 0.125f, 0.0f);
    public static final ModelResourceLocation CLOCK_LOCATION = ECModelHelper.standalone("block/shrine_upgrade_acceleration_clock");
    private BakedModel clockModel;

    public void render(AccelerationShrineUpgradeBlockEntity te, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        BlockState state = te.getBlockState();
        Direction facing = (Direction)state.getValue((Property)AbstractDirectionalShrineUpgradeBlock.FACING);
        Quaternionf rotation = facing.getRotation();
        Vector3f newPos = new Vector3f((Vector3fc)POSITION);
        if (this.clockModel == null) {
            this.clockModel = Minecraft.getInstance().getModelManager().getModel(CLOCK_LOCATION);
        }
        matrixStack.translate(0.5, 0.5, 0.5);
        matrixStack.mulPose(Axis.of((Vector3f)facing.step()).rotation((float)Math.toRadians(ECRendererHelper.getClientTicks(partialTicks))));
        rotation.transform(newPos);
        matrixStack.translate(newPos.x(), newPos.y(), newPos.z());
        matrixStack.mulPose(rotation);
        ECRendererHelper.renderModel(this.clockModel, matrixStack, buffer, te, light, overlay);
    }
}

