/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.upgrade;

import com.google.common.collect.Iterables;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;
import sirttas.dpanvil.api.predicate.block.world.CacheBlockPredicate;
import sirttas.elementalcraft.api.upgrade.AbstractUpgrade;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.data.predicate.block.shrine.HasShrineUpgradePredicate;

public class ShrineUpgrade
extends AbstractUpgrade<BonusType> {
    public static final Codec<ShrineUpgrade> CODEC = RecordCodecBuilder.create(builder -> AbstractUpgrade.codec(builder, BonusType.CODEC).apply((Applicative)builder, ShrineUpgrade::new));

    private ShrineUpgrade(IBlockPosPredicate predicate, Map<BonusType, Float> bonuses, int maxAmount) {
        super(predicate, new EnumMap<BonusType, Float>(bonuses), maxAmount);
    }

    boolean canUpgrade(AbstractShrineBlockEntity shrine, boolean update, Direction direction) {
        int count = shrine.getUpgradeCount(this);
        if (update && count > 0) {
            --count;
        }
        return this.canUpgrade((LevelReader)shrine.getLevel(), shrine.getBlockPos(), direction, count);
    }

    public void addInformation(List<Component> tooltip, @Nonnull TooltipFlag flag) {
        this.bonuses.forEach((type, multiplier) -> tooltip.add((Component)Component.translatable((String)("shrine_upgrade_bonus.elementalcraft." + type.getSerializedName()), (Object[])new Object[]{this.formatMultiplier((Float)multiplier)}).withStyle(type.isPositive() ^ multiplier.floatValue() < 1.0f ? ChatFormatting.BLUE : ChatFormatting.RED)));
        if (this.maxAmount > 0) {
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)Component.translatable((String)"tooltip.elementalcraft.max_amount", (Object[])new Object[]{this.maxAmount}).withStyle(ChatFormatting.YELLOW));
        }
        if (flag.isAdvanced()) {
            tooltip.addAll(this.getPredicateTooltip());
        }
    }

    private String formatMultiplier(Float multiplier) {
        if (multiplier.floatValue() >= 10.0f) {
            return new DecimalFormat("\u00d7#.##").format(multiplier);
        }
        return String.format("%+d%%", Math.round((multiplier.floatValue() - 1.0f) * 100.0f));
    }

    public boolean is(ResourceKey<ShrineUpgrade> key) {
        return key.location().equals((Object)this.getId());
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ShrineUpgrade) {
            return super.equals(other);
        }
        return false;
    }

    public static ShrineUpgrade merge(Stream<ShrineUpgrade> upgrades) {
        AtomicReference atomicValue = new AtomicReference();
        upgrades.forEach(upgrade -> {
            ShrineUpgrade value = (ShrineUpgrade)atomicValue.get();
            if (value == null) {
                atomicValue.set(upgrade);
            } else {
                value.merge(upgrade);
            }
        });
        return (ShrineUpgrade)atomicValue.get();
    }

    public static Builder builder(ResourceKey<ShrineUpgrade> key) {
        return new Builder(key);
    }

    public static class Builder {
        public static final Encoder<Builder> ENCODER = CODEC.comap(builder -> new ShrineUpgrade(builder.getPredicate(), builder.bonuses, builder.maxAmount));
        private final ResourceKey<ShrineUpgrade> key;
        private IBlockPosPredicate predicate;
        private final Map<BonusType, Float> bonuses;
        private int maxAmount;
        private final List<ResourceKey<ShrineUpgrade>> incompatibilities;

        private Builder(ResourceKey<ShrineUpgrade> key) {
            this.key = key;
            this.bonuses = new EnumMap<BonusType, Float>(BonusType.class);
            this.predicate = null;
            this.maxAmount = 0;
            this.incompatibilities = new ArrayList<ResourceKey<ShrineUpgrade>>();
        }

        public Builder match(Block ... block) {
            return this.predicate(IBlockPosPredicate.match((Block[])block));
        }

        public Builder match(TagKey<Block> tag) {
            return this.predicate(IBlockPosPredicate.match(tag));
        }

        public Builder predicate(IBlockPosPredicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public Builder max(int max) {
            this.maxAmount = max;
            return this;
        }

        @SafeVarargs
        public final Builder incompatibleWith(ResourceKey<ShrineUpgrade> ... upgrades) {
            return this.incompatibleWith(Arrays.asList(upgrades));
        }

        public final Builder incompatibleWith(Iterable<ResourceKey<ShrineUpgrade>> upgrades) {
            this.incompatibilities.addAll(StreamSupport.stream(upgrades.spliterator(), false).distinct().filter(k -> k != null && !this.key.equals(k) && !this.incompatibilities.contains(k)).toList());
            return this;
        }

        public Builder addBonus(BonusType type, float value) {
            this.bonuses.put(type, Float.valueOf(value));
            return this;
        }

        private IBlockPosPredicate getPredicate() {
            IBlockPosPredicate iBlockPosPredicate;
            if (this.incompatibilities.isEmpty()) {
                return this.predicate;
            }
            IBlockPosPredicate incompatiblePredicate = (this.incompatibilities.size() == 1 ? new HasShrineUpgradePredicate((ResourceKey<ShrineUpgrade>)((ResourceKey)Iterables.getOnlyElement(this.incompatibilities))) : IBlockPosPredicate.createOr((IBlockPosPredicate[])((IBlockPosPredicate[])this.incompatibilities.stream().map(HasShrineUpgradePredicate::new).toArray(HasShrineUpgradePredicate[]::new)))).not();
            IBlockPosPredicate iBlockPosPredicate2 = this.predicate;
            if (iBlockPosPredicate2 instanceof CacheBlockPredicate) {
                CacheBlockPredicate cacheBlockPredicate = (CacheBlockPredicate)iBlockPosPredicate2;
                iBlockPosPredicate = cacheBlockPredicate.predicate().and(new IBlockPosPredicate[]{incompatiblePredicate}).cache();
            } else {
                iBlockPosPredicate = this.predicate.and(new IBlockPosPredicate[]{incompatiblePredicate});
            }
            return iBlockPosPredicate.simplify();
        }
    }

    public static enum BonusType implements StringRepresentable
    {
        NONE("none", false),
        SPEED("speed", false),
        ELEMENT_CONSUMPTION("element_consumption", false),
        CAPACITY("element_capacity", true),
        RANGE("range", true),
        STRENGTH("strength", true);

        public static final Codec<BonusType> CODEC;
        private final String name;
        private final boolean positive;

        private BonusType(String name, boolean positive) {
            this.name = name;
            this.positive = positive;
        }

        @Nonnull
        public String getSerializedName() {
            return this.name;
        }

        public boolean isPositive() {
            return this.positive;
        }

        public static BonusType byName(String name) {
            for (BonusType bonusType : BonusType.values()) {
                if (!bonusType.name.equals(name)) continue;
                return bonusType;
            }
            return NONE;
        }

        static {
            CODEC = StringRepresentable.fromEnum(BonusType::values);
        }
    }
}

